let orlenWidgetLoaded = false;
let orlenWidgetLoading = false;
let pendingTrigger = null;

const loadOrlenWidget = () => {
  if (orlenWidgetLoaded || orlenWidgetLoading) return;

  orlenWidgetLoading = true;

  window.orlenpaczka = window.orlenpaczka || [];
  const script = document.createElement('script');
  script.async = true;
  script.src = orlenWidgetApi + 'widget.js?token=' + orlenWidgetToken + '&v=1.0.0&t=' + Math.floor(new Date().getTime() / 1000);
  document.head.appendChild(script);
};

const initOrlenWidget = () => {
  // Lazy loading - intercept first click
  document.querySelectorAll('.orlen-widget').forEach(trigger => {
    trigger.addEventListener('click', (e) => {
      if (!orlenWidgetLoaded) {
        e.preventDefault();
        e.stopPropagation();
        e.stopImmediatePropagation();

        pendingTrigger = trigger;
        trigger.textContent = trigger.dataset.labelLoading || 'Loading...';
        trigger.style.pointerEvents = 'none';

        loadOrlenWidget();
      }
    }, true); // capture phase - run before widget's handler
  });

  document.addEventListener('orlenWidgetInit', function() {
    orlenWidgetLoaded = true;
    orlenWidgetLoading = false;

    // Re-click the button after widget is ready
    if (pendingTrigger) {
      pendingTrigger.textContent = pendingTrigger.dataset.labelSelect || 'Select pickup point';
      pendingTrigger.style.pointerEvents = '';
      setTimeout(() => {
        pendingTrigger.click();
        pendingTrigger = null;
      }, 100);
    }

    const widgets = document.querySelectorAll('.orlen-widget-modal');
    const triggerWidgets = document.querySelectorAll('.orlen-widget');

    if (!widgets.length) {
      console.warn('No Orlen widgets found');
      return;
    }

    // Update point details in the UI
    const adjustCarrierExtraContentHeight = (carrierId) => {
      const pickupContainer = document.getElementById(`orlen-pickup-container-${carrierId}`);

      if (!pickupContainer) {
        return;
      }

      const extraContentWrapper = pickupContainer.closest('.js-carrier-extra-content');
      extraContentWrapper.style.maxHeight = 'none';
      extraContentWrapper.style.maxHeight = `${extraContentWrapper.scrollHeight}px`;
    };

    const updatePointDetails = (carrierId, pointData) => {
      console.log(carrierId);
      // Get elements
      const detailsContainer = document.getElementById(`orlen-point-details-${carrierId}`);
      const pointCodeEl = document.getElementById(`point-code-${carrierId}`);
      const pointNameEl = document.getElementById(`point-name-${carrierId}`);
      const pointAddressEl = document.getElementById(`point-address-${carrierId}`);
      const pointCityEl = document.getElementById(`point-city-${carrierId}`);
      const pointPostalCodeEl = document.getElementById(`point-postal-code-${carrierId}`);
      const pointProvinceEl = document.getElementById(`point-province-${carrierId}`);
      const selectedPointInput = document.getElementById(`selected-point-${carrierId}`);
      const idPointInput = document.getElementById(`id-point-${carrierId}`);

      // Update hidden inputs
      if (selectedPointInput) selectedPointInput.value = pointData.destinationCode || '';
      if (idPointInput) idPointInput.value = pointData.id || '';

      // Update visible fields
      if (pointCodeEl) pointCodeEl.textContent = pointData.destinationCode || '';
      if (pointNameEl) pointNameEl.textContent = pointData.physicalNamePsd || '';
      if (pointAddressEl) pointAddressEl.textContent = pointData.addressLine || '';
      if (pointCityEl) pointCityEl.textContent = pointData.city || '';
      if (pointPostalCodeEl) pointPostalCodeEl.textContent = pointData.postalCode || '';
      if (pointProvinceEl) pointProvinceEl.textContent = pointData.province || '';

      // Show details container
      if (detailsContainer) {
        detailsContainer.style.display = '';
      }

      // Update button text
      const btnEl = document.querySelector(`.orlen-widget[data-carrier-id="${carrierId}"]`);


      adjustCarrierExtraContentHeight(carrierId);
    };

    // Track currently selected carrier ID
    let currentCarrierId = null;

    // Add click listeners to trigger widgets to track which carrier is being used
    triggerWidgets.forEach(trigger => {
      const carrierId = trigger.getAttribute('data-carrier-id');
      if (carrierId) {
        trigger.addEventListener('click', () => {
          currentCarrierId = carrierId;
          console.log('Carrier selected:', carrierId);
        });
      }
    });

    // Listen for point selection events
    widgets.forEach((widget) => {
      widget.addEventListener('orlenSelectPoint', (event) => {
        const pointData = event.detail.marker.options;
        console.log('Selected point data:', pointData);

        // Use the tracked carrier ID
        const carrierId = currentCarrierId;
        //
        // // Update UI immediately to give user feedback
        // if (carrierId) {
        //   updatePointDetails(carrierId, pointData);
        // }

        // Send point data to server via AJAX
        $.ajax({
          url: saveSelectedPointUrl,
          method: 'POST',
          dataType: 'json',
          data: {
            id: pointData.id,
            name: pointData.physicalNamePsd,
            destinationCode: pointData.destinationCode,
            address: pointData.addressLine,
            city: pointData.city,
            postalCode: pointData.postalCode,
            province: pointData.province,
            latitude: pointData.latitude,
            longitude: pointData.longitude,
            carrierId: carrierId
          },
          success: function(response) {
            console.log('Point data sent successfully', response);
            console.log(response.carrierId);

            updatePointDetails(response.carrierId, pointData);
            // If server response contains carrier ID (in case it wasn't available earlier)

          },
          error: function(xhr, status, error) {
            console.error('Error sending point data:', error);
          }
        });
      });
    });
  });
};

if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initOrlenWidget);
} else {
  initOrlenWidget();
}

