/**
 * API service for Orlen Paczka module
 */

/**
 * Send form data to the server
 * @param {string} url - The URL to send the data to
 * @param {FormData} formData - The form data to send
 * @returns {Promise<Object>} - Promise resolving to response data
 */
export const sendFormData = async (url, formData) => {
  try {
    const response = await fetch(url, {
      method: 'POST',
      body: formData,
      headers: {
        'X-Requested-With': 'XMLHttpRequest'
      }
    });
    
    return await response.json();
  } catch (error) {
    console.error('Error sending form data:', error);
    throw error;
  }
};

/**
 * Fetch available dates for pickup
 * @param {string} url - The URL to fetch dates from
 * @param {string} postCode - The postal code
 * @returns {Promise<Object>} - Promise resolving to response data
 */
export const fetchAvailableDates = async (url, postCode) => {
  try {
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest'
      },
      body: JSON.stringify({ postCode })
    });
    
    return await response.json();
  } catch (error) {
    console.error('Error fetching available dates:', error);
    throw error;
  }
};

/**
 * Fetch available hours for pickup
 * @param {string} url - The URL to fetch hours from
 * @param {Object} data - The data with date and optional postCode
 * @returns {Promise<Object>} - Promise resolving to response data
 */
export const fetchAvailableHours = async (url, data) => {
  try {
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest'
      },
      body: JSON.stringify(data)
    });
    
    return await response.json();
  } catch (error) {
    console.error('Error fetching available hours:', error);
    throw error;
  }
};
