<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class OrlenPaczkaUpdater_1_0_5
{
    private \Module $module;

    public function upgrade(Module $module)
    {
        $this->module = $module;
        return $this->processOverride();

    }

    public function processOverride()
    {
        try{
            if (!$this->removeOverride()) {
                return false;
            }
            return $this->addOverride();
        } catch (\Exception $e) {
            return false;
        }

    }

    private function removeOverride()
    {
        return $this->module->removeOverride('Order');
    }

    private function addOverride()
    {
        return $this->module->addOverride('Order');
    }

}


/**
 * Upgrade module to version 1.0.3

 */
function upgrade_module_1_0_5(Module $module)
{
    $updater = new OrlenPaczkaUpdater_1_0_5();
    return $updater->upgrade($module);

}


