<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class OrlenPaczkaUpdater_1_3_0
{
    private \Module $module;
    private string $overrideRemove;
    private string $override;
    private string $overrideTmp;

    public function upgrade(Module $module)
    {
        $this->module = $module;
        $this->overrideRemove = _PS_MODULE_DIR_.$this->module->name.'/overrideRemove';
        $this->override = _PS_MODULE_DIR_.$this->module->name.'/override';
        $this->overrideTmp = _PS_MODULE_DIR_.$this->module->name.'/overrideTmp';


        if (
            $this->processHooks()
        && $this->processTabs()
        && $this->processOverride()
        ) {
            return true;
        }

        return false;
    }

    public function processHooks()
    {
        $result = true;

        $result &= $this->module->unregisterHook('actionCarrierProcess');
        $result &= $this->module->registerHook('actionObjectModelGetWebserviceParameters');

        return $result;
    }

    public function processTabs()
    {
        $sql = new \DbQuery();
        $sql->select('id_tab');
        $sql->from('tab');
        $sql->where('module = "orlenpaczka"');
        $idTab = (int)\Db::getInstance()->getValue($sql);

        $tab = new \Tab($idTab);
        $tab->active = false;
        $tab->enabled = true;
        $tab->class_name = 'AdminOrlenPaczka';
        $tab->name = [];

        foreach (\Language::getLanguages() as $lang) {
            $tab->name[$lang['id_lang']] = 'AdminOrlenPaczka';
        }
        $tab->id_parent = 0;
        $tab->module = $this->module->name;

        return (bool)$tab->save() && \Tab::initAccess($tab->id);
    }

    public function processOverride()
    {
        try{
            if (!$this->removeOverride()) {
                return false;
            }
            return $this->addOverride();
        } catch (\Exception $e) {
            return false;
        }

    }

    private function removeOverride()
    {
        $fileSystem = new Symfony\Component\Filesystem\Filesystem();
        $fileSystem->rename($this->override, $this->overrideTmp);
        $fileSystem->rename($this->overrideRemove, $this->override);
        return $this->module->removeOverride('Order');
    }

    private function addOverride()
    {
        $fileSystem = new Symfony\Component\Filesystem\Filesystem();
        $fileSystem->rename($this->override, $this->overrideRemove);
        $fileSystem->rename($this->overrideTmp, $this->override);
        return $this->module->addOverride('Order') && $this->module->addOverride('ObjectModel');
    }

}


/**
 * Upgrade module to version 1.0.3

 */
function upgrade_module_1_0_3(Module $module)
{
    $updater = new OrlenPaczkaUpdater_1_3_0();
    return $updater->upgrade($module);

}


