<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Upgrade module to version 1.0.2
 * - Allow id_pickup to be NULL in orlenpaczka_package table
 * - Unregister old hooks: displayAdminOrderTop, displayAdminOrder
 * - Register new hook: displayAdminOrderMainBottom
 */
function upgrade_module_1_0_2($module)
{
    // Zmiana kolumny id_pickup na nullable
    $sql = "ALTER TABLE `" . _DB_PREFIX_ . "orlenpaczka_package`
            MODIFY COLUMN `id_pickup` INT(10) UNSIGNED NULL";

    if (!Db::getInstance()->execute($sql)) {
        return false;
    }

    // Odrejestrowanie starych hooków
    $module->unregisterHook('displayAdminOrderTop');
    $module->unregisterHook('displayAdminOrder');

    // Rejestracja nowego hooka
    if (!$module->registerHook('displayAdminOrderMainBottom')) {
        return false;
    }

    return true;
}
