<?php

namespace Orlen\OrlenPaczka\Voter;

class VoteManager
{
    private $voters;

    public function __construct($voters)
    {
        $this->voters = $voters;
    }

    public function vote(string $type, $params)
    {
        foreach ($this->voters as $voter) {
            $methodName = $voter->supports($type, $params);
            if ($methodName  && is_callable([$voter, $methodName])) {
                return $voter->{$methodName}($params);
            }
        }
    }
}
