<?php

namespace Orlen\OrlenPaczka\View;

class OrderView
{
    /**
     * @var \DateTime|null
     */
    private $packageDateLabelGenerate;

    /**
     * @var string|null
     */
    private $packageLabelDownloadLink;

    private $packageGridLink;

    /**
     * @var string|null
     */
    private $packageTrackingUrl;

    /**
     * @var string|null
     */
    private $packageSize;

    /**
     * @var string|null
     */
    private $pickupPoint;

    /**
     * @var string|null
     */
    private $pickupDestinationCode;

    /**
     * @var string|null
     */
    private $pickupAddress;

    /**
     * @var string|null
     */
    private $pickupCity;

    /**
     * @var string|null
     */
    private $pickupPostalCode;

    /**
     * @var string|null
     */
    private $protocolCode;

    /**
     * @var string|null
     */
    private $protocolLabelDownloadLink;

    /**
     * @var \DateTime|null
     */
    private $protocolDateLabelGenerate;
    /**
     * @var bool|null
     */
    private  $allowRegenerateLabel;
    /**
     * @var int|null
     */
    private $pickupId;
    /**
     * @var int|null
     */
    private $formId;

    /**
     * @var string|null
     */
    private $duplicateUrl;

    /**
     * @var string|null
     */
    private $packageCode;

    /**
     * @var bool
     */
    private $hasPickupPoint = false;

    /**
     * @return \DateTime|null
     */
    public function getPackageDateLabelGenerate(): ?\DateTime
    {
        return $this->packageDateLabelGenerate;
    }

    /**
     * @param \DateTime|null $packageDateLabelGenerate
     * @return OrderView
     */
    public function setPackageDateLabelGenerate(?\DateTime $packageDateLabelGenerate): OrderView
    {
        $this->packageDateLabelGenerate = $packageDateLabelGenerate;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPackageLabelDownloadLink(): ?string
    {
        return $this->packageLabelDownloadLink;
    }

    /**
     * @param string|null $packageLabelDownloadLink
     * @return OrderView
     */
    public function setPackageLabelDownloadLink(?string $packageLabelDownloadLink): OrderView
    {
        $this->packageLabelDownloadLink = $packageLabelDownloadLink;
        return $this;
    }

    /**
     * Metoda dla naprawienia literówki z metody _presentPackage
     * @param string|null $packageLabelDownloadLink
     * @return OrderView
     */
    public function sePackageLabelDownloadLink(?string $packageLabelDownloadLink): OrderView
    {
        return $this->setPackageLabelDownloadLink($packageLabelDownloadLink);
    }

    /**
     * @return string|null
     */
    public function getPackageTrackingUrl(): ?string
    {
        return $this->packageTrackingUrl;
    }

    /**
     * @param string|null $packageTrackingUrl
     * @return OrderView
     */
    public function setPackageTrackingUrl(?string $packageTrackingUrl): OrderView
    {
        $this->packageTrackingUrl = $packageTrackingUrl;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPackageSize(): ?string
    {
        return $this->packageSize;
    }

    /**
     * @param string|null $packageSize
     * @return OrderView
     */
    public function setPackageSize(?string $packageSize): OrderView
    {
        $this->packageSize = $packageSize;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPickupPoint(): ?string
    {
        return $this->pickupPoint;
    }

    /**
     * @param string|null $pickupPoint
     * @return OrderView
     */
    public function setPickupPoint(?string $pickupPoint): OrderView
    {
        $this->pickupPoint = $pickupPoint;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPickupDestinationCode(): ?string
    {
        return $this->pickupDestinationCode;
    }

    /**
     * @param string|null $pickupDestinationCode
     * @return OrderView
     */
    public function setPickupDestinationCode(?string $pickupDestinationCode): OrderView
    {
        $this->pickupDestinationCode = $pickupDestinationCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPickupAddress(): ?string
    {
        return $this->pickupAddress;
    }

    /**
     * @param string|null $pickupAddress
     * @return OrderView
     */
    public function setPickupAddress(?string $pickupAddress): OrderView
    {
        $this->pickupAddress = $pickupAddress;
        return $this;
    }

    /**
     * Metoda dla naprawienia literówki z metody _presentPackage
     * @param string|null $pickupAddress
     * @return OrderView
     */
    public function setPickuAddress(?string $pickupAddress): OrderView
    {
        return $this->setPickupAddress($pickupAddress);
    }

    /**
     * @return string|null
     */
    public function getPickupCity(): ?string
    {
        return $this->pickupCity;
    }

    /**
     * @param string|null $pickupCity
     * @return OrderView
     */
    public function setPickupCity(?string $pickupCity): OrderView
    {
        $this->pickupCity = $pickupCity;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPickupPostalCode(): ?string
    {
        return $this->pickupPostalCode;
    }

    /**
     * @param string|null $pickupPostalCode
     * @return OrderView
     */
    public function setPickupPostalCode(?string $pickupPostalCode): OrderView
    {
        $this->pickupPostalCode = $pickupPostalCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getProtocolCode(): ?string
    {
        return $this->protocolCode;
    }

    /**
     * @param string|null $protocolCode
     * @return OrderView
     */
    public function setProtocolCode(?string $protocolCode): OrderView
    {
        $this->protocolCode = $protocolCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getProtocolLabelDownloadLink(): ?string
    {
        return $this->protocolLabelDownloadLink;
    }

    /**
     * @param string|null $protocolLabelDownloadLink
     * @return OrderView
     */
    public function setProtocolLabelDownloadLink(?string $protocolLabelDownloadLink): OrderView
    {
        $this->protocolLabelDownloadLink = $protocolLabelDownloadLink;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getProtocolDateLabelGenerate(): ?\DateTime
    {
        return $this->protocolDateLabelGenerate;
    }

    /**
     * @param \DateTime|null $protocolDateLabelGenerate
     * @return OrderView
     */
    public function setProtocolDateLabelGenerate(?\DateTime $protocolDateLabelGenerate): OrderView
    {
        $this->protocolDateLabelGenerate = $protocolDateLabelGenerate;
        return $this;
    }

    public function setAllowRegenerateLabel(bool $allowRegenerateLabel): void
    {
        $this->allowRegenerateLabel = $allowRegenerateLabel;
    }

    public function getAllowRegenerateLabel(): ?bool
    {
        return $this->allowRegenerateLabel;
    }

    public function setPickupId($id)
    {
        $this->pickupId = $id;
    }

    public function getPickupId(): ?int
    {
        return $this->pickupId;
    }

    /**
     * @param int|null $formId
     * @return OrderView
     */
    public function setFormId(?int $formId): OrderView
    {
        $this->formId = $formId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFormId(): ?int
    {
        return $this->formId;
    }

    public function getDuplicateUrl(): ?string
    {
        return $this->duplicateUrl;
    }

    public function setDuplicateUrl(?string $duplicateUrl): void
    {
        $this->duplicateUrl = $duplicateUrl;
    }

    /**
     * @return mixed
     */
    public function getPackageGridLink()
    {
        return $this->packageGridLink;
    }

    /**
     * @param mixed $packageGridLink
     */
    public function setPackageGridLink($packageGridLink): void
    {
        $this->packageGridLink = $packageGridLink;
    }

    public function getPackageCode(): ?string
    {
        return $this->packageCode;
    }

    public function setPackageCode(?string $packageCode): void
    {
        $this->packageCode = $packageCode;
    }

    /**
     * @return bool
     */
    public function getHasPickupPoint(): bool
    {
        return $this->hasPickupPoint;
    }

    /**
     * @param bool $hasPickupPoint
     * @return OrderView
     */
    public function setHasPickupPoint(bool $hasPickupPoint): OrderView
    {
        $this->hasPickupPoint = $hasPickupPoint;
        return $this;
    }
}
