<?php

namespace Orlen\OrlenPaczka\Translator;

use Orlen\OrlenPaczka\Configuration\Enum\SenderOrdersTypeEnum;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class SenderOrdersTypeTranslator
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }
    public function translate()
    {
        return [
            $this->translator->trans('Order ID', [], 'Modules.Orlenpaczka.Form') => SenderOrdersTypeEnum::ORDER_ID,
            $this->translator->trans('Order Reference', [], 'Modules.Orlenpaczka.Form') => SenderOrdersTypeEnum::ORDER_REFERENCE,
            $this->translator->trans('Custom', [], 'Modules.Orlenpaczka.Form') => SenderOrdersTypeEnum::OWN_SENDER_ORDERS,
            $this->translator->trans('None', [], 'Modules.Orlenpaczka.Form') => SenderOrdersTypeEnum::NONE,
        ];
    }

    public function getTranslationByType($type)
    {
        switch ($type){
            case SenderOrdersTypeEnum::ORDER_ID:
                return $this->translator->trans('Order ID', [], 'Modules.Orlenpaczka.Form');
            case SenderOrdersTypeEnum::ORDER_REFERENCE:
                return $this->translator->trans('Order Reference', [], 'Modules.Orlenpaczka.Form');
            case SenderOrdersTypeEnum::OWN_SENDER_ORDERS:
                return $this->translator->trans('Custom', [], 'Modules.Orlenpaczka.Form');
            case SenderOrdersTypeEnum::NONE:
                return $this->translator->trans('None', [], 'Modules.Orlenpaczka.Form');
        }
    }
}
