<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\XsdTypeCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\XsdType;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\Visitor\ListVisitor;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\Visitor\SimpleTypeVisitor;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\Visitor\UnionVisitor;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\Visitor\XsdTypeVisitorInterface;

final class XsdTypesParser
{
    /**
     * @var XsdTypeVisitorInterface[]
     */
    private $visitors;

    public function __construct(XsdTypeVisitorInterface ...$visitors)
    {
        $this->visitors = $visitors;
    }

    public static function default(): self
    {
        return new self(
            new ListVisitor(),
            new UnionVisitor(),
            new SimpleTypeVisitor()
        );
    }

    public function parse(\SoapClient $client): XsdTypeCollection
    {
        $collected = [];
        $soapTypes = (array) $client->__getTypes();
        foreach ($soapTypes as $soapType) {
            if ($type = $this->detectXsdType($soapType)) {
                $collected[] = $type;
            }
        }

        return new XsdTypeCollection(...$collected);
    }

    private function detectXsdType(string $soapType): ?XsdType
    {
        foreach ($this->visitors as $visitor) {
            if ($type = $visitor($soapType)) {
                return $type;
            }
        }

        return null;
    }
}
