<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\MethodCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\TypeCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\XsdTypeCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\MetadataInterface;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\MethodsParser;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\TypesParser;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata\XsdTypesParser;

final class ExtSoapMetadata implements MetadataInterface
{
    /**
     * @var AbusedClient
     */
    private $abusedClient;
    /**
     * @var XsdTypeCollection|null
     */
    private $xsdTypes;

    public function __construct(AbusedClient $abusedClient)
    {
        $this->abusedClient = $abusedClient;
    }

    public function getMethods(): MethodCollection
    {
        return (new MethodsParser($this->getXsdTypes()))->parse($this->abusedClient);
    }

    public function getTypes(): TypeCollection
    {
        return (new TypesParser($this->getXsdTypes()))->parse($this->abusedClient);
    }

    private function getXsdTypes(): XsdTypeCollection
    {
        if (null === $this->xsdTypes) {
            $this->xsdTypes = XsdTypesParser::default()->parse($this->abusedClient);
        }

        return $this->xsdTypes;
    }
}
