<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Engine\Metadata;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\MethodCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\TypeCollection;

final class LazyInMemoryMetadata implements MetadataInterface
{
    /**
     * @var MetadataInterface
     */
    private $metadata;
    /**
     * @var TypeCollection|null
     */
    private $types;
    /**
     * @var MethodCollection|null
     */
    private $methods;

    public function __construct(MetadataInterface $metadata)
    {
        $this->metadata = $metadata;
    }

    public function getTypes(): TypeCollection
    {
        return $this->types ?? ($this->types = $this->metadata->getTypes());
    }

    public function getMethods(): MethodCollection
    {
        return $this->methods ?? ($this->methods = $this->metadata->getMethods());
    }
}
