<?php

namespace Orlen\OrlenPaczka\Repository;

use Orlen\OrlenPaczka\Entity\PackageSelectedPoint;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\Persistence\ManagerRegistry;
use Orlen\OrlenPaczka\Entity\SelectedPoint;

/**
 * @extends ServiceEntityRepository<PackageSelectedPoint>
 *
 * @method PackageSelectedPoint|null find($id, $lockMode = null, $lockVersion = null)
 * @method PackageSelectedPoint|null findOneBy(array $criteria, array $orderBy = null)
 * @method PackageSelectedPoint[]    findAll()
 * @method PackageSelectedPoint[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PackageSelectedPointRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PackageSelectedPoint::class);
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function add(PackageSelectedPoint $entity, bool $flush = true): void
    {
        $this->_em->persist($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function remove(PackageSelectedPoint $entity, bool $flush = true): void
    {
        $this->_em->remove($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    public function createPackageSelectedPointFromSelectedPoint(SelectedPoint $selectedPoint):PackageSelectedPoint
    {
        $packageSelectedPoint = $this->findOneBy(['destinationCode' => $selectedPoint->getDestinationCode()]);
        if (empty($packageSelectedPoint))
        {
            $packageSelectedPoint = new PackageSelectedPoint();
        }
        $packageSelectedPoint->setPoint($selectedPoint->getPoint());
        $packageSelectedPoint->setName($selectedPoint->getName());
        $packageSelectedPoint->setCity($selectedPoint->getCity());
        $packageSelectedPoint->setAddress($selectedPoint->getAddress());
        $packageSelectedPoint->setLatitude($selectedPoint->getLatitude());
        $packageSelectedPoint->setLongitude($selectedPoint->getLongitude());
        $packageSelectedPoint->setDestinationCode($selectedPoint->getDestinationCode());
        $packageSelectedPoint->setPostalCode($selectedPoint->getPostalCode());
        $packageSelectedPoint->setProvince($selectedPoint->getProvince());
        return $packageSelectedPoint;
    }

    // /**
    //  * @return PackageSelectedPoint[] Returns an array of PackageSelectedPoint objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('p.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?PackageSelectedPoint
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
