<?php

namespace Orlen\OrlenPaczka\Renderer;

use Orlen\OrlenPaczka\Repository\SelectedPointRepository;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;

class CarrierRenderer
{
    private \Context $context;
    private SelectedPointRepository $selectedPointRepository;
    private ShipmentRepository $shipmentRepository;
    public function __construct(
        \Context $context,
        SelectedPointRepository $selectedPointRepository,
        ShipmentRepository $shipmentRepository
    )
    {
        $this->context = $context;
        $this->selectedPointRepository = $selectedPointRepository;
        $this->shipmentRepository = $shipmentRepository;
    }
    public function renderCarrier(array $carrier)
    {
        $shipment = $this->shipmentRepository->findOneBy(['carrier' => $carrier['id_reference']]);
        if ($shipment === null) {
            return;
        }
        if ($shipment->getMapActive()) {
            $selectedPoint =$this->selectedPointRepository->findOneBy(['carrier' => $carrier['id'], 'cart' => $this->context->cart->id]);
            if ($selectedPoint){
                $this->context->smarty->assign(
                    [
                        'selected_point' => $selectedPoint->getDestinationCode()?? null,
                        'name' => $selectedPoint->getName()?? null,
                        'id_carrier' => $carrier['id'],
                        'id_point' => $selectedPoint->getPoint()?? null,
                        'address' => $selectedPoint->getAddress()?? null,
                        'city' => $selectedPoint->getCity()?? null,
                        'postal_code' => $selectedPoint->getPostalCode()?? null,
                        'province' => $selectedPoint->getProvince()?? null,
                    ]
                );
            }else{

                $this->context->smarty->assign(
                    [
                        'selected_point' =>  null,
                        'id_carrier' => $carrier['id']

                    ]
                );
            }

            return $this->context->smarty->fetch('module:orlenpaczka/views/templates/hook/carrier-extra-content.tpl');
        }
    }
}
