<?php

namespace Orlen\OrlenPaczka\Label\Provider;

use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\BusinessPack;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Label\Interfaces\PackageProvider;
use Orlen\OrlenPaczka\Label\Settings\GenerateLabelSettings;
use Orlen\OrlenPaczka\Repository\PackageRepository;

class BusinessPackPackageProvider implements PackageProvider
{
    private PackageRepository $packageRepository;
    private \Module $module;

    public function __construct(PackageRepository $packageRepository, \Module $module )
    {
        $this->packageRepository = $packageRepository;
        $this->module = $module;
    }
    public function getData( GenerateLabelSettings $settings) : ArrayOfBusinessPack
    {
        $idPackages = $settings->getSettings()['provider']['id_packages'];
        $arrayOfBusinessPack = new ArrayOfBusinessPack();
        $data = $this->packageRepository->getDataLabel($idPackages, $settings->getSettings()['allow_regenerate']);
        $settingsData = $settings->getSettings();
        foreach ($data as $row) {
            $settingsData['package_order'][] = $row['id_package'];
            $businessPack = new BusinessPack();
            $businessPack = $this->fillData($settings->getSettings(),$businessPack);
            $businessPack = $this->fillData(['TransferDescription' => ConfigurationModule::PLATFORM.'_'.$this->module->version], $businessPack,);
            $businessPack = $this->fillData($row, $businessPack);
            if (isset($settings->getSettings()['provider']['form_data'])){
                $businessPack = $this->fillData($settings->getSettings()['provider']['form_data'], $businessPack);
            }
            $settingsData['sender_orders'][$row['id_package']] = $businessPack->getSenderOrders();

            $arrayOfBusinessPack->addBusinessPack($businessPack);
        }
        $settings->setSettings($settingsData);
        return $arrayOfBusinessPack;
    }

    /**
     * @param $data
     * @param array $result
     * @return array
     */
    public function fillData($data, BusinessPack $businessPack): BusinessPack
    {
        foreach ($data as $key => $value) {
            if ($value === null || $value === '') {
                continue;
            }
            $methodKey = ucfirst($key);
            $methodName = 'with' . $methodKey;
            if (method_exists($businessPack, $methodName)) {
                $businessPack = $businessPack->$methodName($value);
            }

        }
        return $businessPack;
    }
}
