<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    Waynet
 * @copyright Waynet
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

namespace Orlen\OrlenPaczka\Iterators;

if (!defined('_PS_VERSION_')) {
    exit;
}

abstract class CollectionIterator implements \Countable, \Iterator
{
    protected $collection = [];

    protected $key = 0;

    public function current(): mixed
    {
        return $this->collection[$this->key];
    }

    public function next(): void
    {
        ++$this->key;
    }

    public function key(): mixed
    {
        return $this->key;
    }

    public function valid(): bool
    {
        return isset($this->collection[$this->key]);
    }

    public function rewind(): void
    {
        $this->key = 0;
    }

    public function count(): int
    {
        return count($this->collection);
    }
}
