<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use Przelewy24\Configuration\ModuleConfiguration;

class DisplayHeader implements HookInterface
{
    private \Context $context;

    public function __construct(\Context $context)
    {
        $this->context = $context;
    }
    public function execute($params)
    {
        if (!$this->context->controller instanceof \OrderController) {
            return '';
        }
        $token =\Configuration::get(ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_TOKEN);
        if (empty($token)) {
            return '';
        }
        $this->context->controller->registerJavascript(
            'orlenpaczka-carrier',
            'modules/orlenpaczka/views/js/front/carrier.js',
            [
                'position' => 'bottom',
            ]
        );
        \Media::addJsDef([
            'saveSelectedPointUrl' => $this->context->link->getModuleLink('orlenpaczka', 'points', ['ajax' => 1, 'action' => 'saveSelectedPoint']),
            'orlenWidgetApi' => ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_API,
            'orlenWidgetToken' => $token,
        ]);
        return '';
    }

}
