<?php

namespace Orlen\OrlenPaczka\Grid\Definition\Factory;

use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\BooleanColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\PositionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractFilterableGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\Filter;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;
use PrestaShopBundle\Form\Admin\Type\DateRangeType;
use PrestaShopBundle\Form\Admin\Type\SearchAndResetType;
use PrestaShopBundle\Form\Admin\Type\YesAndNoChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class ShipmentGridDefinitionFactory extends AbstractFilterableGridDefinitionFactory
{
    public const GRID_ID = 'orlenpaczka_shipment';

    public function __construct(
        Translator $translator,
        HookDispatcherInterface $hookDispatcher = null
    ) {
        parent::__construct($hookDispatcher ?? new NullDispatcher());
        $this->setTranslator($translator);
    }

    protected function getId(): string
    {
        return self::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Shipments', [], 'Modules.Orlenpaczka.Admin');
    }

    protected function getColumns(): ColumnCollection
    {
        return (new ColumnCollection())
            ->add(
                (new IdentifierColumn('id_shipment'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id_shipment',
                    ])
            )
            ->add(
                (new DataColumn('id_carrier_reference'))
                    ->setName($this->trans('Carrier', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'id_carrier_reference',
                    ])
            )
            ->add(
                (new BooleanColumn('carrier_active'))
                    ->setName($this->trans('Carrier active', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'carrier_active',
                        'true_name' => $this->trans('Yes', [], 'Admin.Global'),
                        'false_name' => $this->trans('No', [], 'Admin.Global'),
                    ])
            )
            ->add(
                (new BooleanColumn('map_active'))
                    ->setName($this->trans('Map active', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'map_active',
                        'true_name' => $this->trans('Yes', [], 'Admin.Global'),
                        'false_name' => $this->trans('No', [], 'Admin.Global'),
                    ])
            )
            ->add(
                (new DataColumn('size'))
                    ->setName($this->trans('Size', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'size',
                    ])
            )
//            ->add(
//                (new DataColumn('insurance_amount'))
//                    ->setName($this->trans('Insurance amount', [], 'Modules.Orlenpaczka.Admin'))
//                    ->setOptions([
//                        'field' => 'insurance_amount',
//                    ])
//            )
            ->add(
                (new DataColumn('sender_orders'))
                    ->setName($this->trans('Sender orders', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'sender_orders',
                    ])
            )
            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getFilters()
    {
        return (new FilterCollection())
            ->add(
                (new Filter('id_shipment', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_shipment')
            )
            ->add(
                (new Filter('id_carrier_reference', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search carrier', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_carrier_reference')
            )
            ->add(
                (new Filter('carrier_active', YesAndNoChoiceType::class))
                    ->setTypeOptions([
                        'required' => false,
                    ])
                    ->setAssociatedColumn('carrier_active')
            )
            ->add(
                (new Filter('map_active', YesAndNoChoiceType::class))
                    ->setTypeOptions([
                        'required' => false,
                    ])
                    ->setAssociatedColumn('map_active')
            )
            ->add(
                (new Filter('size', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search size', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('size')
            )
            ->add(
                (new Filter('sender_orders', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search sender orders', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('sender_orders')
            )
            ->add(
                (new Filter('actions', SearchAndResetType::class))
                    ->setTypeOptions([
                        'reset_route' => 'admin_common_reset_search_by_filter_id',
                        'reset_route_params' => [
                            'filterId' => self::GRID_ID,
                        ],
                        'redirect_route' => 'orlenpaczka.config.shipment.index',
                    ])
                    ->setAssociatedColumn('actions')
            );
    }

    protected function getGridActions()
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            )
            ->add(
                (new SimpleGridAction('common_show_query'))
                    ->setName($this->trans('Show SQL query', [], 'Admin.Actions'))
                    ->setIcon('code')
            )
            ->add(
                (new SimpleGridAction('common_export_sql_manager'))
                    ->setName($this->trans('Export to SQL Manager', [], 'Admin.Actions'))
                    ->setIcon('storage')
            );
    }

    private function getRowActions()
    {
        return (new RowActionCollection())
            ->add(
                (new LinkRowAction('edit'))
                    ->setName($this->trans('Edit', [], 'Admin.Actions'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.shipment.edit',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_shipment',
                    ])
                    ->setIcon('edit')
            )
            ->add(
                (new SubmitRowAction('delete'))
                    ->setName($this->trans('Delete', [], 'Admin.Actions'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.shipment.delete',
                        'method' => 'DELETE',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_shipment',
                        'confirm_message' => $this->trans(
                            'Delete selected item?',
                            [],
                            'Admin.Notifications.Warning'
                        ),
                    ])
                    ->setIcon('delete')
            );
    }
}
