<?php

namespace Orlen\OrlenPaczka\Form\Type;

use Orlen\OrlenPaczka\Choice\Translator\ChoiceTranslator;
use Orlen\OrlenPaczka\Configuration\Enum\FormatEnum;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class GenerateLabelType extends AbstractType
{
    private Translator $translator;
    private RouterInterface $router;
    private ChoiceTranslator $choiceTranslator;

    public function __construct(Translator $translator, RouterInterface $router, ChoiceTranslator $choiceTranslator)
    {
        $this->translator = $translator;
        $this->router = $router;
        $this->choiceTranslator = $choiceTranslator;
    }
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->setAction($this->router->generate($options['url_action']))
            ->add('format', ChoiceType::class, [
                'label' => $this->translator->trans('Format Label', [], 'Modules.Orlenpaczka.Form'),
                'choices' => FormatEnum::toArray()
            ])
//            ->add('PrintType', ChoiceType::class, [
//                'label' => $this->translator->trans('Format Label', [], 'Admin.Global'),
//                'choices' => $this->choiceTranslator->translatePrintType()
//            ])
//            ->add('PrintAdress', ChoiceType::class, [
//                'label' => $this->translator->trans('Print Address', [], 'Admin.Global'),
//                'choices' => $this->choiceTranslator->translatePrintAddress()
//            ])
            ->add('packageIds', CollectionType::class, [
                'allow_add' => true,
                'entry_type' => HiddenType::class,
                'label' => false,
            ])
            ->get('packageIds')
            ->addModelTransformer(new CallbackTransformer(
                static function ($packageIds) {
                    return $packageIds;
                },
                static function (array $packageIds) {
                    return array_map(static function ($packageIds) {
                        return (int) $packageIds;
                    }, $packageIds);
                }
            ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setRequired([
            'url_action'
        ]);
    }
}
