<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Form\Type;

use Orlen\OrlenPaczka\Configuration\Enum\ConfigFormEnum;
use Orlen\OrlenPaczka\Form\Dto\Authorization;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

class AuthorizationType extends AbstractType
{
    private RouterInterface $router;
    private Translator $translator;

    public function __construct(RouterInterface $router, Translator $translator)
    {

        $this->router = $router;
        $this->translator = $translator;
    }
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
//            ->setAction($this->router->generate('orlenpaczka.index', ['type' => ConfigFormEnum::AUTHORIZATION]))
            ->add('sandbox', SwitchType::class,
                [
                    'label' => $this->translator->trans('Sandbox', [], 'Modules.Orlenpaczka.Form'),
                    'required' => true,
                    'attr' =>
                        [
                            'data-url' => $this->router->generate('orlenpaczka.config.authorization.update_sandbox')
                        ]
                ])
            ->add('partner_id', TextType::class,
                [
                    'label' => $this->translator->trans('Partner ID', [], 'Modules.Orlenpaczka.Form'),
                    'required' => true
                ])
            ->add('partner_key', PasswordType::class, [
                'label' => $this->translator->trans('Partner Key', [], 'Modules.Orlenpaczka.Form'),
                'required' => true,
            ])
            ->add('token', TextType::class,
                [
                    'label' => $this->translator->trans('token', [], 'Modules.Orlenpaczka.Form'),
                    'required' => true,
                ]);

    }

    public function finishView(FormView $view, FormInterface $form, array $options)
    {
        $data = $form->getData();
        if (!$data instanceof Authorization) {
            return;
        }

        $view['partner_key']->vars['value'] = $data->getPartnerKey();
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Authorization::class,
        ]);
    }
}
