<?php

namespace Orlen\OrlenPaczka\Form\Handler;

use Doctrine\ORM\EntityManagerInterface;
use Orlen\OrlenPaczka\Api\OrlenPaczka\OrlenPaczkaClientFactory;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CallPickupNew;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickups;
use Orlen\OrlenPaczka\Entity\Delivery;
use Orlen\OrlenPaczka\Form\Handler\Exception\PackageInDelivery;
use Orlen\OrlenPaczka\Form\Handler\Voter\CanPackagesCallPickupVoter;
use Orlen\OrlenPaczka\Protocol\Exception\PackageNoLabel;
use Orlen\OrlenPaczka\Repository\DeliveryRepository;
use Orlen\OrlenPaczka\Repository\PackageRepository;
use Orlen\OrlenPaczka\Repository\ProtocolRepository;
use Orlen\OrlenPaczka\Voter\VoteManager;

class CallPickupHandler
{
    private OrlenPaczkaClientFactory $factory;
    private PackageRepository $oackageRepository;
    private DeliveryRepository $deliveryRepository;
    private VoteManager $voteManager;
    private EntityManagerInterface $entityManager;

    public function __construct(
        OrlenPaczkaClientFactory $factory,
        PackageRepository $oackageRepository,
        DeliveryRepository $deliveryRepository,
        VoteManager $voteManager,
        EntityManagerInterface $entityManager
    )
    {
        $this->factory = $factory;
        $this->oackageRepository = $oackageRepository;
        $this->deliveryRepository = $deliveryRepository;
        $this->voteManager = $voteManager;
        $this->entityManager = $entityManager;
    }
    public function handle(array $data)
    {
        $packages = $this->oackageRepository->findBy(['id' => $data['packageIds']]);

        $this->_voteCanPickup($packages);



        $packList = [];
        foreach ($packages as $package){
            $packList[] = $package->getPackCode();
        }

        $time = explode('-', $data['pickup_hours']);
        $readyDate = new \DateTime($data['pickup_date'].' '.$time[0]);
        $pickupDate = new \DateTime($data['pickup_date'].' '.$time[1]);

        $client = $this->factory->factory();
        $credentials = $client->getCredentials();
        $response = $client->callPickupNew(new CallPickupNew(
            $credentials->getPartnerId(),
            $credentials->getPartnerKey(),
            $packList,
            $readyDate,
            $pickupDate,
            $data['PostCode'],
            $data['City'],
            $data['Street'],
            $data['BulidingNo']??null,
            $data['Email'],
            $data['PartnerName'],
            $data['PersonName']??null,
            $data['PersonSurname']??null,
            $data['Telephone']??null

        ));
        $response = $response->getCallPickupNewResult();
        if ($response->getErr() != 0 || $response->getErr() === null) {
            throw new \Exception($response->getErrDes());
        }

        $code =$response->getData();
        $delivery = $this->deliveryRepository->findOneBy(['code' => $code]);
        if (empty($delivery)){
            $delivery = new Delivery();
            $delivery->setCode($code);
            $delivery->setDatePickup($readyDate);
            $delivery->setHourPickupFrom($readyDate);
            $delivery->setHourPickupTo($pickupDate);
        }else{

            foreach ($delivery->getProtocols() as $protocol) {
                $this->entityManager->remove($protocol);
            }
            foreach ($delivery->getPackages() as $package) {
                $package->setProtocol(null);
                $this->entityManager->persist($package);
            }
        }

        foreach ($packages as $package){
            $delivery->addPackage($package);
        }


        $this->entityManager->persist($delivery);
        $this->entityManager->flush();


    }

    private function _voteCanPickup($packages)
    {
        if (!$this->voteManager->vote(CanPackagesCallPickupVoter::PACKAGES_HAS_LABEL, $packages)) {
            throw new PackageNoLabel('Package no label');
        }
//        if (!$this->voteManager->vote(CanPackagesCallPickupVoter::PACKAGES_NOT_IN_DELIVERY, $packages)) {
//            throw new PackageInDelivery('Package in delivery');
//        }
    }
}
