<?php

namespace Orlen\OrlenPaczka\Entity;

use Orlen\OrlenPaczka\Repository\ShipmentTypeRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=ShipmentTypeRepository::class)
 * @ORM\Table(name=ShipmentType::TABLE_NAME)
 */
class ShipmentType
{
    /**
     * @internal
     */
    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_shipment_type';

    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_shipment_type")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\OneToOne(targetEntity=Shipment::class, mappedBy="shipmentType")
     */
    private $shipment;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getShipment(): ?Shipment
    {
        return $this->shipment;
    }

    public function setShipment(Shipment $shipment): self
    {
        // set the owning side of the relation if necessary
        if ($shipment->getShipmentType() !== $this) {
            $shipment->setShipmentType($this);
        }

        $this->shipment = $shipment;

        return $this;
    }
}
