<?php

namespace Orlen\OrlenPaczka\Entity;

use Orlen\OrlenPaczka\Repository\PackageRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=PackageRepository::class)
 * @ORM\Table(name=Package::TABLE_NAME)
 */
class Package
{
    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_package';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_package")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", name="id_order")
     */
    private $idOrder;


    /**
     * @ORM\ManyToOne(targetEntity=PackageSelectedPoint::class, cascade={"persist"})
     * @ORM\JoinColumn(nullable=false, name="id_pickup", referencedColumnName="id_pickup", nullable=true)
     */
    private $pickup;

    /**
     * @ORM\ManyToOne(targetEntity=Shipment::class)
     * @ORM\JoinColumn(nullable=false, name="id_shipment", referencedColumnName="id_shipment")
     */
    private $shipment;

    /**
     * @ORM\Column(type="string", length=255, name="partner_id")
     */
    private $partnerId;

    /**
     * @ORM\Column(type="string", length=255, nullable=true, name="pack_code")
     */
    private $packCode;

    /**
     * @ORM\Column(type="string", length=255, nullable=true, name="label_name")
     */
    private $labelName;

    /**
     * @ORM\Column(type="datetime", name="label_date_generated", nullable=true)
     */
    private $labelDateGenerated;

    /**
     * @ORM\ManyToOne(targetEntity=Protocol::class, inversedBy="packages" )
     * @ORM\JoinColumn(nullable=true, name="id_protocol", referencedColumnName="id_protocol")
     */
    private $protocol;

    /**
     * @ORM\ManyToOne(targetEntity=Delivery::class, inversedBy="packages")
     * @ORM\JoinColumn(nullable=true, name="id_delivery", referencedColumnName="id_delivery", nullable=true)
     */
    private $delivery;

    /**
     * @ORM\Column(type="string", length=5)
     */
    private $size;

    /**
     * @ORM\Column(type="string", length=30, nullable=true, name="sender_orders")
     */
    private $senderOrders;

    /**
     * @ORM\OneToOne(targetEntity=PackageData::class, inversedBy="package", cascade={"persist", "remove"})
     * @ORM\JoinColumn(nullable=true, name="id_package_data", referencedColumnName="id_package_data")
     */
    private $data;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIdOrder(): ?int
    {
        return $this->idOrder;
    }

    public function setIdOrder(int $idOrder): self
    {
        $this->idOrder = $idOrder;

        return $this;
    }

    public function getPickup(): ?PackageSelectedPoint
    {
        return $this->pickup;
    }

    public function setPickup(?PackageSelectedPoint $pickup): self
    {
        $this->pickup = $pickup;

        return $this;
    }

    public function getShipment(): ?Shipment
    {
        return $this->shipment;
    }

    public function setShipment(?Shipment $shipment): self
    {
        $this->shipment = $shipment;

        return $this;
    }

    public function getPartnerId(): ?string
    {
        return $this->partnerId;
    }

    public function setPartnerId(string $partnerId): self
    {
        $this->partnerId = $partnerId;

        return $this;
    }

    public function getPackCode(): ?int
    {
        return $this->packCode;
    }

    public function setPackCode(?int $packCode): self
    {
        $this->packCode = $packCode;

        return $this;
    }

    public function getLabelName(): ?string
    {
        return $this->labelName;
    }

    public function setLabelName(?string $labelName): self
    {
        $this->labelName = $labelName;

        return $this;
    }

    public function getLabelDateGenerated(): ?\DateTimeInterface
    {
        return $this->labelDateGenerated;
    }

    public function setLabelDateGenerated(?\DateTimeInterface $labelDateGenerated): self
    {
        $this->labelDateGenerated = $labelDateGenerated;

        return $this;
    }

    public function getProtocol(): ?Protocol
    {
        return $this->protocol;
    }

    public function setProtocol(?Protocol $protocol): self
    {
        $this->protocol = $protocol;

        return $this;
    }

    public function getDelivery(): ?Delivery
    {
        return $this->delivery;
    }

    public function setDelivery(?Delivery $delivery): self
    {
        $this->delivery = $delivery;

        return $this;
    }

    public function getSize(): ?string
    {
        return $this->size;
    }

    public function setSize(string $size): self
    {
        $this->size = $size;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getSenderOrders(): ?string
    {
        return $this->senderOrders;
    }

    /**
     * @param mixed $senderOrders
     */
    public function setSenderOrders(?string $senderOrders): self
    {
        $this->senderOrders = $senderOrders;
        return $this;
    }

    public function getData(): ?PackageData
    {
        return $this->data;
    }

    public function setData(?PackageData $data): self
    {
        $this->data = $data;

        return $this;
    }


}
