<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Controller\Admin;

use Orlen\OrlenPaczka\Form\Type\CallPickupType;
use Orlen\OrlenPaczka\Protocol\Exception\ProtocolExistOrNoLabel;
use Orlen\OrlenPaczka\Protocol\Generator\ProtocolGenerator;
use Orlen\OrlenPaczka\Protocol\Settings\GenerateProtocolSettings;
use Orlen\OrlenPaczka\Repository\DeliveryRepository;
use Orlen\OrlenPaczka\Search\Filters\DeliveryFilters;
use Orlen\OrlenPaczka\Search\Filters\ProtocolFilters;
use Orlen\OrlenPaczka\Tabs\Tab\OrderCourierTab;
use Orlen\OrlenPaczka\Tabs\Tab\ShippingHistoryTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShop\PrestaShop\Core\Grid\Presenter\GridPresenterInterface;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

/**
 * @Route(path="/config", name="orlenpaczka.config.delivery")
 */
class DeliveryController extends FrameworkBundleAdminController
{

    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @Route("/delivery", name=".index", methods={"GET"})
     */
    public function deliveryGridAction(
        \Module $module,
        Tabs $tabs,
        GridPresenterInterface $gridPresenter,
        DeliveryFilters $filters,
        OrderCourierTab $orderCourierTab,
        $gridFactoryDelivery
    )
    {
        $orderCourierTab->setActive();
        $grid = $gridPresenter->present($gridFactoryDelivery->getGrid($filters));

        $form = $this->createForm(CallPickupType::class);


        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/delivery_grid.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'grid' => $grid,
            'form' => $form->createView(),
            'title' => $this->translator->trans('Shipment', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
    /**
     * @Route("/delivery/generate-protocol/{id}", name=".generate_protocol", methods={"GET"})
     */
    public function generateProtocolAction(
        $id,
        ProtocolGenerator $generatorProtocolFromPackage,
        Request $request,
        GenerateProtocolSettings $settings,
        DeliveryRepository $deliveryRepository
    )
    {
        $delivery = $deliveryRepository->find($id);
        if (empty($delivery)){
            $this->addFlash('error', $this->translator->trans('Delivery not exist updated', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }
        if (!$delivery->getProtocols()->isEmpty()){
            $this->addFlash('error', $this->translator->trans('Protocol Exist', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }
        $packages = $delivery->getPackages();
        $packageIDs = [];
        foreach ($packages as $package) {
            $packageIDs[] = $package->getId();
        }

        if (empty($packageIDs)){
            $this->addFlash('error', $this->translator->trans('No packages to generate', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }
        $settings->setSettings([
            'provider' => ['id_packages' => $packageIDs, 'delivery' => $delivery],
        ]);
        try{
            $generatorProtocolFromPackage->generateProtocol($settings);
            foreach ($generatorProtocolFromPackage->getSuccess() as $row) {
                $this->addFlash('success', $row);
            }

            foreach ($generatorProtocolFromPackage->getErrors() as $row) {
                $this->addFlash('error', $row);
            }
//            $this->addFlash('success', $this->translator->trans('Protocol updated', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }catch (\Exception $e){
            $this->addFlash('error', $this->translator->trans('Error generate protocol', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }catch (ProtocolExistOrNoLabel $e){
            $this->addFlash('error', $this->translator->trans('Protocol Exist or no label', [], 'Modules.Orlenpaczka.Tab'));
            return $this->redirectToRoute('orlenpaczka.config.delivery.index');
        }

    }
}
