<?php

namespace Orlen\OrlenPaczka\Choice\Translator;

use Orlen\OrlenPaczka\Configuration\Enum\PrintAdressEnum;
use Orlen\OrlenPaczka\Configuration\Enum\PrintTypeEnum;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class ChoiceTranslator
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    public function translatePrintAddress()
    {
        return array_flip([
            PrintAdressEnum::RETURN_ADDRESS => $this->translator->trans('Return Address', [], 'Modules.Orlenpaczka.Form'),
            PrintAdressEnum::SENDER_ADDRESS => $this->translator->trans('Sender Address', [], 'Modules.Orlenpaczka.Form'),
        ]);
    }

    public function translatePrintType()
    {
        return array_flip([
            PrintTypeEnum::FULL_ADDRESS => $this->translator->trans('Full Address', [], 'Modules.Orlenpaczka.Form'),
            PrintTypeEnum::ONLY_NAME_ADDRESS => $this->translator->trans('Only Name Address', [], 'Modules.Orlenpaczka.Form'),
            PrintTypeEnum::ANONYMOUS_ADDRESS => $this->translator->trans('Anonymous Address', [], 'Modules.Orlenpaczka.Form'),
        ]);
    }
}
