<?php

namespace Orlen\OrlenPaczka\Carrier\Voter;

use Orlen\OrlenPaczka\Carrier\Exception\NotSelectedPointForCarrierException;
use Orlen\OrlenPaczka\Carrier\Exception\PhoneIsMissingException;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Repository\SelectedPointRepository;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;
use Orlen\OrlenPaczka\Voter\Interfaces\VoterInterface;
use Orlen\OrlenPaczka\Voter\VoteManager;

class CarrierCompletedVoter implements VoterInterface
{
    private ShipmentRepository $shipmentRepository;
    private SelectedPointRepository $selectedPointRepository;
    private VoteManager $voteManager;

    public function __construct(
        ShipmentRepository $shipmentRepository,
        SelectedPointRepository $selectedPointRepository,
        VoteManager $voteManager
    )
    {
        $this->shipmentRepository = $shipmentRepository;
        $this->selectedPointRepository = $selectedPointRepository;
        $this->voteManager = $voteManager;
    }
    public const CARRIER_COMPLETE_VOTER = 'CARRIER_COMPLETE_VOTER';
    public function supports(string $type, $params): ?string
    {
        switch ($type) {
            case self::CARRIER_COMPLETE_VOTER:
                return ($params instanceof \Cart)?
                     'voteCarrierIsComplete':
                     null;
            default:
                return null;
        }
    }

    public function voteCarrierIsComplete(\Cart $cart):bool
    {
        $carrier = new \Carrier($cart->id_carrier);
        if (!$this->voteManager->vote(CarrierIsModuleVoter::CARRIER_IS_MODULE_VOTER, $carrier)) {
            return true;
        }
        $shipment = $this->shipmentRepository->findOneBy(['carrier' => $carrier->id_reference]);
        if ($shipment === null) {
            throw new CarrierNotActiveException('Carrier is not actve');
        }
        if (!$shipment->getCarrierActive()) {
            throw new CarrierNotActiveException('Carrier is not actve');
        }

        $address = new \Address($cart->id_address_delivery);

        if (empty($address->phone) && empty($address->phone_mobile)) {
            throw new PhoneIsMissingException('Point is not selected');
        }
        if ($shipment->getMapActive()) {
            $selectedPoint = $this->selectedPointRepository->findOneBy(['carrier' => $carrier->id, 'cart' => $cart->id]);
            if ($selectedPoint === null) {
                throw new NotSelectedPointForCarrierException('Point is not selected');
            }
            if ($selectedPoint->getCarrier() != $carrier->id) {
                throw new NotSelectedPointForCarrierException('Point is not selected');
            }
            if ($selectedPoint->getPoint() === null || $selectedPoint->getDestinationCode() === null) {
                throw new NotSelectedPointForCarrierException('Point is not selected');
            }
            return true;
        }

        return true;


    }

}
