<?php

namespace Orlen\OrlenPaczka\Carrier\Creator;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Helper\Lang\LangHelper;

class CarrierCreator
{
    public function create()
    {
        $carrier = new \Carrier();
        $carrier->name = 'ORLEN Paczka';
        $carrier->url = 'https://www.orlenpaczka.pl/sledz-paczke/?numer=@';
        $carrier->active = true;
        $carrier->shipping_external = true;
        $carrier->is_module = true;
        $carrier->need_range = true;
        $carrier->external_module_name = ConfigurationModule::MODULE_NAME;
        $carrier->delay = LangHelper::createLangArrayForValue('24-48H');
        $carrier->save();
        $groups = \Group::getGroups(\Context::getContext()->language->id);
        $groups = array_column($groups, 'id_group');
        $carrier->setGroups($groups);


        !file_exists(ConfigurationModule::LABEL_PATH) || !copy(ConfigurationModule::LOGO_PATH, _PS_SHIP_IMG_DIR_ . $carrier->id . '.jpg');
        return $carrier->id;
    }
}
