<?php

namespace Orlen\OrlenPaczka\CallPickup\Provider;

use Orlen\OrlenPaczka\Api\OrlenPaczka\OrlenPaczkaClientFactory;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickups;

class PickupHoursProvider
{
    private OrlenPaczkaClientFactory $clientFactory;

    public function __construct(OrlenPaczkaClientFactory $clientFactory)
    {
        $this->clientFactory = $clientFactory;
    }

    /**
     * Generuje przedziały godzin co 2h od minimalnej do maksymalnej godziny
     * z uwzględnieniem minimalnego interwału
     *
     * @param int $minHour Minimalna godzina (np. 8)
     * @param int $maxHour Maksymalna godzina (np. 18)
     * @param int $minimumInterval Minimalny interwał w minutach (np. 120)
     * @return array Tablica przedziałów godzin w formacie [['value' => '08:00-10:00', 'label' => '8:00 - 10:00'], ...]
     */
    private function _createHours(int $minHour, int $maxHour, int $minimumInterval = 120): array
    {
        $hours = [];
        $interval = 2; // Stały interwał co 2 godziny

        // Zaokrąglenie minimalnej godziny w górę do pełnej parzystej godziny
        $startHour = (int)$minHour;
//        if ($startHour % $interval !== 0) {
//            $startHour = $startHour + ($interval - ($startHour % $interval));
//        }

        for ($hour = $startHour; $hour < $maxHour; $hour += $interval) {
            $endHour = $hour + $interval;

            // Sprawdź czy ostatni przedział nie przekracza maksymalnej godziny
            if ($endHour > $maxHour) {
                break;
            }

            // Usunięto sprawdzanie minimalnego interwału - dodajemy wszystkie przedziały
            // które mieszczą się w zakresie od minHour do maxHour

            // Formatowanie godzin (dodanie wiodącego zera)
            $startFormatted = sprintf('%02d:00', $hour);
            $endFormatted = sprintf('%02d:00', $endHour);

            $hours[] = [
                'value' => "{$startFormatted}-{$endFormatted}",
                'label' => "{$hour}:00 - {$endHour}:00"
            ];
        }

        return $hours;
    }

    public function getHours($postalCode, $selectedDate)
    {
        $selectedDate = new \DateTime($selectedDate);

        $client = $this->clientFactory->factory();
        $credentials = $client->getCredentials();
        $response = $client->getAvailablePickups(new GetAvailablePickups(
            $credentials->getPartnerId(),
            $credentials->getPartnerKey(),
            $postalCode,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null
        ));
        $data = $response->getGetAvailablePickupsResult();
        if ($data->getErr() != 0) {
            throw new \Exception($data->getErrDes());
        }

        $dates = $data->getData()->getAvailablePickupDay();
        $availableHours = [];

        foreach ($dates as $date) {
            $dateTime = new \DateTime($date->getDate());
            if ($dateTime == $selectedDate) {
                $maxPickupDate = new \DateTime($date->getMaxPickupDate());
                $minPickupDate = new \DateTime($date->getMinReadyDate());
                $today = new \DateTime();
                $maxHour = (int)$maxPickupDate->format('H');
                if ($today > $minPickupDate){
                    $minHour = (int)$today->modify('+1 hour')->format('H');
                }else{
                    $minHour = (int)$minPickupDate->format('H');
                }

                $minimumInterval = (int)$date->getMinimumInterval(); // Pobranie minimalnego interwału

                // Generowanie przedziałów godzin
                $availableHours = $this->_createHours($minHour, $maxHour, $minimumInterval);

                // Znaleziono godziny dla wybranej daty, możemy zakończyć pętlę
                break;
            }
        }
        return $availableHours;
//        return [
//            'success' => true,
//            'hours' => [
//                'from' => $availableHours // Format oczekiwany przez frontend
//            ]
//        ];
    }
}
