<?php

namespace Orlen\OrlenPaczka\CallPickup\Provider;

use Orlen\OrlenPaczka\Api\OrlenPaczka\OrlenPaczkaClientFactory;
use Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickups;
use Orlen\OrlenPaczka\Exception\IncorrectCredentialsException;

class PickupDateProvider
{
    private OrlenPaczkaClientFactory $clientFactory;

    public function __construct(OrlenPaczkaClientFactory $clientFactory)
    {
        $this->clientFactory = $clientFactory;
    }

    public function getDates($postalCode)
    {
        $client = $this->clientFactory->factory();
        $credentials = $client->getCredentials();
        $response =$client->getAvailablePickups(new GetAvailablePickups(
            $credentials->getPartnerId(),
            $credentials->getPartnerKey(),
            $postalCode,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null
        ));
        $data = $response->getGetAvailablePickupsResult();
        if ($data->getErr() != 0 || $data->getErr() === null) {
            if ($data->getErrDes() == 'incorrect PartnerID or PartnerKey'){
                throw new IncorrectCredentialsException($data->getErrDes());
            }
            throw new \Exception($data->getErrDes());
        }
        $dates = $data->getData()->getAvailablePickupDay();
        $availableDates = [];
        foreach ($dates as $date) {
            $dateTime = new \DateTime($date->getDate());
            $availableDates[] = [
                'value' => $dateTime->format('Y-m-d'),
                'label' => $dateTime->format('d.m.Y'),
            ];
        }

        return  $availableDates;


    }
}
