<?php

namespace Orlen\OrlenPaczka\Authorization\Dto;

class Connection implements ConnectionInterface
{
    private bool $sandbox;
    private string $wsdl;
    private ?CredentialsInterface $credentials;

    /**
     * @param bool $sandbox
     * @param string $wsdl
     */
    public function __construct(bool $sandbox, string $wsdl, ?CredentialsInterface $credentials)
    {
        $this->sandbox = $sandbox;
        $this->wsdl = $wsdl;
        $this->credentials = $credentials;
    }

    public function isSandbox(): bool
    {
        return $this->sandbox;
    }

    public function getWsdl(): string
    {
        return $this->wsdl;
    }

    public function getCredentials(): ?CredentialsInterface
    {
        return $this->credentials;
    }






}
