<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class PackagesToBeReturned
{

    /**
     * @var int
     */
    private $PSD_Z;

    /**
     * @var int
     */
    private $Transakcja;

    /**
     * @var int
     */
    private $PackCode;

    /**
     * @var \DateTimeInterface
     */
    private $Data;

    /**
     * @return int
     */
    public function getPSD_Z()
    {
        return $this->PSD_Z;
    }

    /**
     * @param int $PSD_Z
     * @return PackagesToBeReturned
     */
    public function withPSD_Z($PSD_Z)
    {
        $new = clone $this;
        $new->PSD_Z = $PSD_Z;

        return $new;
    }

    /**
     * @return int
     */
    public function getTransakcja()
    {
        return $this->Transakcja;
    }

    /**
     * @param int $Transakcja
     * @return PackagesToBeReturned
     */
    public function withTransakcja($Transakcja)
    {
        $new = clone $this;
        $new->Transakcja = $Transakcja;

        return $new;
    }

    /**
     * @return int
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param int $PackCode
     * @return PackagesToBeReturned
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getData()
    {
        return $this->Data;
    }

    /**
     * @param \DateTimeInterface $Data
     * @return PackagesToBeReturned
     */
    public function withData($Data)
    {
        $new = clone $this;
        $new->Data = $Data;

        return $new;
    }


}

