<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GiveMePackStatusFullHistory implements RequestInterface
{

    /**
     * @var string
     */
    private $PackCode;

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * Constructor
     *
     * @var string $PackCode
     * @var string $PartnerID
     * @var string $PartnerKey
     */
    public function __construct($PackCode, $PartnerID, $PartnerKey)
    {
        $this->PackCode = $PackCode;
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param string $PackCode
     * @return GiveMePackStatusFullHistory
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GiveMePackStatusFullHistory
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GiveMePackStatusFullHistory
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }


}

