<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GiveMePackStatus implements RequestInterface
{

    /**
     * @var string
     */
    private $PhoneNumber;

    /**
     * @var string
     */
    private $PackCode;

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * Constructor
     *
     * @var string $PhoneNumber
     * @var string $PackCode
     * @var string $PartnerID
     * @var string $PartnerKey
     */
    public function __construct($PhoneNumber, $PackCode, $PartnerID, $PartnerKey)
    {
        $this->PhoneNumber = $PhoneNumber;
        $this->PackCode = $PackCode;
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return GiveMePackStatus
     */
    public function withPhoneNumber($PhoneNumber)
    {
        $new = clone $this;
        $new->PhoneNumber = $PhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param string $PackCode
     * @return GiveMePackStatus
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GiveMePackStatus
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GiveMePackStatus
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }


}

