<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GiveMasterPack implements RequestInterface
{

    /**
     * @var string
     */
    private $packCode;

    /**
     * Constructor
     *
     * @var string $packCode
     */
    public function __construct($packCode)
    {
        $this->packCode = $packCode;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->packCode;
    }

    /**
     * @param string $packCode
     * @return GiveMasterPack
     */
    public function withPackCode($packCode)
    {
        $new = clone $this;
        $new->packCode = $packCode;

        return $new;
    }


}

