<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateStandardCustomerReturn implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PrintLabel;

    /**
     * @var string
     */
    private $Format;

    /**
     * @var string
     */
    private $PrintType;

    /**
     * @var string
     */
    private $BoxSize;

    /**
     * @var string
     */
    private $Insurance;

    /**
     * @var string
     */
    private $SenderFirstName;

    /**
     * @var string
     */
    private $SenderLastName;

    /**
     * @var string
     */
    private $SenderCompanyName;

    /**
     * @var string
     */
    private $SenderStreetName;

    /**
     * @var string
     */
    private $SenderBuildingNumber;

    /**
     * @var string
     */
    private $SenderFlatNumber;

    /**
     * @var string
     */
    private $SenderCity;

    /**
     * @var string
     */
    private $SenderPostCode;

    /**
     * @var string
     */
    private $SenderEMail;

    /**
     * @var string
     */
    private $SenderPhoneNumber;

    /**
     * @var string
     */
    private $SenderOrders;

    /**
     * @var string
     */
    private $ExternalSenderPackageNumber;

    /**
     * @var string
     */
    private $ExternalPackageNumber;

    /**
     * @var string
     */
    private $PackValue;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PrintLabel
     * @var string $Format
     * @var string $PrintType
     * @var string $BoxSize
     * @var string $Insurance
     * @var string $SenderFirstName
     * @var string $SenderLastName
     * @var string $SenderCompanyName
     * @var string $SenderStreetName
     * @var string $SenderBuildingNumber
     * @var string $SenderFlatNumber
     * @var string $SenderCity
     * @var string $SenderPostCode
     * @var string $SenderEMail
     * @var string $SenderPhoneNumber
     * @var string $SenderOrders
     * @var string $ExternalSenderPackageNumber
     * @var string $ExternalPackageNumber
     * @var string $PackValue
     */
    public function __construct($PartnerID, $PartnerKey, $PrintLabel, $Format, $PrintType, $BoxSize, $Insurance, $SenderFirstName, $SenderLastName, $SenderCompanyName, $SenderStreetName, $SenderBuildingNumber, $SenderFlatNumber, $SenderCity, $SenderPostCode, $SenderEMail, $SenderPhoneNumber, $SenderOrders, $ExternalSenderPackageNumber, $ExternalPackageNumber, $PackValue)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PrintLabel = $PrintLabel;
        $this->Format = $Format;
        $this->PrintType = $PrintType;
        $this->BoxSize = $BoxSize;
        $this->Insurance = $Insurance;
        $this->SenderFirstName = $SenderFirstName;
        $this->SenderLastName = $SenderLastName;
        $this->SenderCompanyName = $SenderCompanyName;
        $this->SenderStreetName = $SenderStreetName;
        $this->SenderBuildingNumber = $SenderBuildingNumber;
        $this->SenderFlatNumber = $SenderFlatNumber;
        $this->SenderCity = $SenderCity;
        $this->SenderPostCode = $SenderPostCode;
        $this->SenderEMail = $SenderEMail;
        $this->SenderPhoneNumber = $SenderPhoneNumber;
        $this->SenderOrders = $SenderOrders;
        $this->ExternalSenderPackageNumber = $ExternalSenderPackageNumber;
        $this->ExternalPackageNumber = $ExternalPackageNumber;
        $this->PackValue = $PackValue;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateStandardCustomerReturn
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateStandardCustomerReturn
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrintLabel()
    {
        return $this->PrintLabel;
    }

    /**
     * @param string $PrintLabel
     * @return GenerateStandardCustomerReturn
     */
    public function withPrintLabel($PrintLabel)
    {
        $new = clone $this;
        $new->PrintLabel = $PrintLabel;

        return $new;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }

    /**
     * @param string $Format
     * @return GenerateStandardCustomerReturn
     */
    public function withFormat($Format)
    {
        $new = clone $this;
        $new->Format = $Format;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }

    /**
     * @param string $PrintType
     * @return GenerateStandardCustomerReturn
     */
    public function withPrintType($PrintType)
    {
        $new = clone $this;
        $new->PrintType = $PrintType;

        return $new;
    }

    /**
     * @return string
     */
    public function getBoxSize()
    {
        return $this->BoxSize;
    }

    /**
     * @param string $BoxSize
     * @return GenerateStandardCustomerReturn
     */
    public function withBoxSize($BoxSize)
    {
        $new = clone $this;
        $new->BoxSize = $BoxSize;

        return $new;
    }

    /**
     * @return string
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }

    /**
     * @param string $Insurance
     * @return GenerateStandardCustomerReturn
     */
    public function withInsurance($Insurance)
    {
        $new = clone $this;
        $new->Insurance = $Insurance;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderFirstName()
    {
        return $this->SenderFirstName;
    }

    /**
     * @param string $SenderFirstName
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderFirstName($SenderFirstName)
    {
        $new = clone $this;
        $new->SenderFirstName = $SenderFirstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderLastName()
    {
        return $this->SenderLastName;
    }

    /**
     * @param string $SenderLastName
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderLastName($SenderLastName)
    {
        $new = clone $this;
        $new->SenderLastName = $SenderLastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderCompanyName()
    {
        return $this->SenderCompanyName;
    }

    /**
     * @param string $SenderCompanyName
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderCompanyName($SenderCompanyName)
    {
        $new = clone $this;
        $new->SenderCompanyName = $SenderCompanyName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderStreetName()
    {
        return $this->SenderStreetName;
    }

    /**
     * @param string $SenderStreetName
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderStreetName($SenderStreetName)
    {
        $new = clone $this;
        $new->SenderStreetName = $SenderStreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderBuildingNumber()
    {
        return $this->SenderBuildingNumber;
    }

    /**
     * @param string $SenderBuildingNumber
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderBuildingNumber($SenderBuildingNumber)
    {
        $new = clone $this;
        $new->SenderBuildingNumber = $SenderBuildingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderFlatNumber()
    {
        return $this->SenderFlatNumber;
    }

    /**
     * @param string $SenderFlatNumber
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderFlatNumber($SenderFlatNumber)
    {
        $new = clone $this;
        $new->SenderFlatNumber = $SenderFlatNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderCity()
    {
        return $this->SenderCity;
    }

    /**
     * @param string $SenderCity
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderCity($SenderCity)
    {
        $new = clone $this;
        $new->SenderCity = $SenderCity;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderPostCode()
    {
        return $this->SenderPostCode;
    }

    /**
     * @param string $SenderPostCode
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderPostCode($SenderPostCode)
    {
        $new = clone $this;
        $new->SenderPostCode = $SenderPostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderEMail()
    {
        return $this->SenderEMail;
    }

    /**
     * @param string $SenderEMail
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderEMail($SenderEMail)
    {
        $new = clone $this;
        $new->SenderEMail = $SenderEMail;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderPhoneNumber()
    {
        return $this->SenderPhoneNumber;
    }

    /**
     * @param string $SenderPhoneNumber
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderPhoneNumber($SenderPhoneNumber)
    {
        $new = clone $this;
        $new->SenderPhoneNumber = $SenderPhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderOrders()
    {
        return $this->SenderOrders;
    }

    /**
     * @param string $SenderOrders
     * @return GenerateStandardCustomerReturn
     */
    public function withSenderOrders($SenderOrders)
    {
        $new = clone $this;
        $new->SenderOrders = $SenderOrders;

        return $new;
    }

    /**
     * @return string
     */
    public function getExternalSenderPackageNumber()
    {
        return $this->ExternalSenderPackageNumber;
    }

    /**
     * @param string $ExternalSenderPackageNumber
     * @return GenerateStandardCustomerReturn
     */
    public function withExternalSenderPackageNumber($ExternalSenderPackageNumber)
    {
        $new = clone $this;
        $new->ExternalSenderPackageNumber = $ExternalSenderPackageNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getExternalPackageNumber()
    {
        return $this->ExternalPackageNumber;
    }

    /**
     * @param string $ExternalPackageNumber
     * @return GenerateStandardCustomerReturn
     */
    public function withExternalPackageNumber($ExternalPackageNumber)
    {
        $new = clone $this;
        $new->ExternalPackageNumber = $ExternalPackageNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackValue()
    {
        return $this->PackValue;
    }

    /**
     * @param string $PackValue
     * @return GenerateStandardCustomerReturn
     */
    public function withPackValue($PackValue)
    {
        $new = clone $this;
        $new->PackValue = $PackValue;

        return $new;
    }


}

