<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateProtocol implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfUnsignedLong
     */
    private $parcels;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfUnsignedLong $parcels
     */
    public function __construct($PartnerID, $PartnerKey, array $parcels)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->parcels = $parcels;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateProtocol
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateProtocol
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfUnsignedLong
     */
    public function getParcels()
    {
        return $this->parcels;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfUnsignedLong $parcels
     * @return GenerateProtocol
     */
    public function withParcels($parcels)
    {
        $new = clone $this;
        $new->parcels = $parcels;

        return $new;
    }


}

