<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateLabelBusinessPackListTwo implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $AutoDestinationChange;

    /**
     * @var string
     */
    private $Format;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack
     */
    private $BusinessPackList;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $AutoDestinationChange
     * @var string $Format
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\BusinessPack[] $BusinessPackList
     */
    public function __construct($PartnerID, $PartnerKey, $AutoDestinationChange, $Format, array $BusinessPackList)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->AutoDestinationChange = $AutoDestinationChange;
        $this->Format = $Format;
        $this->BusinessPackList = $BusinessPackList;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateLabelBusinessPackListTwo
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateLabelBusinessPackListTwo
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getAutoDestinationChange()
    {
        return $this->AutoDestinationChange;
    }

    /**
     * @param string $AutoDestinationChange
     * @return GenerateLabelBusinessPackListTwo
     */
    public function withAutoDestinationChange($AutoDestinationChange)
    {
        $new = clone $this;
        $new->AutoDestinationChange = $AutoDestinationChange;

        return $new;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }

    /**
     * @param string $Format
     * @return GenerateLabelBusinessPackListTwo
     */
    public function withFormat($Format)
    {
        $new = clone $this;
        $new->Format = $Format;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack
     */
    public function getBusinessPackList()
    {
        return $this->BusinessPackList;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack $BusinessPackList
     * @return GenerateLabelBusinessPackListTwo
     */
    public function withBusinessPackList($BusinessPackList)
    {
        $new = clone $this;
        $new->BusinessPackList = $BusinessPackList;

        return $new;
    }


}

