<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka;

use Orlen\OrlenPaczka\Api\OrlenPaczka\Exception\MissingCredentialsException;
use Orlen\OrlenPaczka\Authorization\Dto\CredentialsInterface;
use Orlen\OrlenPaczka\Soap\Client\Caller\CallerInterface;
use Orlen\OrlenPaczka\Soap\Client\Exception\SoapException;
use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;
use Orlen\OrlenPaczka\Soap\Client\Type\ResultInterface;

class OrlenPaczkaClient
{

    private $caller;
    private $sandbox;
    private ?CredentialsInterface $credentials;

    public function __construct(CallerInterface $caller, ?CredentialsInterface $credentials, bool $sandbox)
    {
        $this->caller = $caller;
        $this->credentials = $credentials;
        $this->sandbox = $sandbox;
    }

    /**
     * Get the credentials used for the soap client.
     *
     * @return CredentialsInterface
     *
     * @throws MissingCredentialsException If the credentials are not set.
     */
    public function getCredentials(): CredentialsInterface
    {
        if (!($this->credentials instanceof CredentialsInterface)) {
            throw new MissingCredentialsException('Credentials not set');
        }
        return $this->credentials;
    }

    public function isSandbox(): bool
    {
        return $this->sandbox;
    }





    private function call(string $name, RequestInterface $parameters): ResultInterface
    {
        return $this->caller->call($name, $parameters);
    }

    /**
     * @param RequestInterface|Type\Ping $parameters
     * @return ResultInterface|Type\PingResponse
     * @throws SoapException
     */
    public function ping(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\Ping $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PingResponse
    {
        return $this->call('Ping', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePackStatusFullHistoryList $parameters
     * @return ResultInterface|Type\GiveMePackStatusFullHistoryListResponse
     * @throws SoapException
     */
    public function giveMePackStatusFullHistoryList(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusFullHistoryList $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusFullHistoryListResponse
    {
        return $this->call('GiveMePackStatusFullHistoryList', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePackStatusFullHistory $parameters
     * @return ResultInterface|Type\GiveMePackStatusFullHistoryResponse
     * @throws SoapException
     */
    public function giveMePackStatusFullHistory(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusFullHistory $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusFullHistoryResponse
    {
        return $this->call('GiveMePackStatusFullHistory', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeShippingCodeStatusFullHistory $parameters
     * @return ResultInterface|Type\GiveMeShippingCodeStatusFullHistoryResponse
     * @throws SoapException
     */
    public function giveMeShippingCodeStatusFullHistory(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeShippingCodeStatusFullHistory $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeShippingCodeStatusFullHistoryResponse
    {
        return $this->call('GiveMeShippingCodeStatusFullHistory', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePackStatus $parameters
     * @return ResultInterface|Type\GiveMePackStatusResponse
     * @throws SoapException
     */
    public function giveMePackStatus(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatus $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusResponse
    {
        return $this->call('GiveMePackStatus', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePackStatusList $parameters
     * @return ResultInterface|Type\GiveMePackStatusListResponse
     * @throws SoapException
     */
    public function giveMePackStatusList(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusList $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePackStatusListResponse
    {
        return $this->call('GiveMePackStatusList', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMasterPack $parameters
     * @return ResultInterface|Type\GiveMasterPackResponse
     * @throws SoapException
     */
    public function giveMasterPack(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMasterPack $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMasterPackResponse
    {
        return $this->call('GiveMasterPack', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveCurrentPack $parameters
     * @return ResultInterface|Type\GiveCurrentPackResponse
     * @throws SoapException
     */
    public function giveCurrentPack(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveCurrentPack $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveCurrentPackResponse
    {
        return $this->call('GiveCurrentPack', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllRUCHWithFilled $parameters
     * @return ResultInterface|Type\GiveMeAllRUCHWithFilledResponse
     * @throws SoapException
     */
    public function giveMeAllRUCHWithFilled(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHWithFilled $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHWithFilledResponse
    {
        return $this->call('GiveMeAllRUCHWithFilled', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllRUCHWithFilledD1 $parameters
     * @return ResultInterface|Type\GiveMeAllRUCHWithFilledD1Response
     * @throws SoapException
     */
    public function giveMeAllRUCHWithFilledD1(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHWithFilledD1 $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHWithFilledD1Response
    {
        return $this->call('GiveMeAllRUCHWithFilledD1', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllRUCHZipcode $parameters
     * @return ResultInterface|Type\GiveMeAllRUCHZipcodeResponse
     * @throws SoapException
     */
    public function giveMeAllRUCHZipcode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHZipcode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHZipcodeResponse
    {
        return $this->call('GiveMeAllRUCHZipcode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllRUCHLocation $parameters
     * @return ResultInterface|Type\GiveMeAllRUCHLocationResponse
     * @throws SoapException
     */
    public function giveMeAllRUCHLocation(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHLocation $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllRUCHLocationResponse
    {
        return $this->call('GiveMeAllRUCHLocation', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllPSDLocation $parameters
     * @return ResultInterface|Type\GiveMeAllPSDLocationResponse
     * @throws SoapException
     */
    public function giveMeAllPSDLocation(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllPSDLocation $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllPSDLocationResponse
    {
        return $this->call('GiveMeAllPSDLocation', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllLocationWithAllData $parameters
     * @return ResultInterface|Type\GiveMeAllLocationWithAllDataResponse
     * @throws SoapException
     */
    public function giveMeAllLocationWithAllData(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllLocationWithAllData $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllLocationWithAllDataResponse
    {
        return $this->call('GiveMeAllLocationWithAllData', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllLocationWithAllDataWithZipCode $parameters
     * @return ResultInterface|Type\GiveMeAllLocationWithAllDataWithZipCodeResponse
     * @throws SoapException
     */
    public function giveMeAllLocationWithAllDataWithZipCode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllLocationWithAllDataWithZipCode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllLocationWithAllDataWithZipCodeResponse
    {
        return $this->call('GiveMeAllLocationWithAllDataWithZipCode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeAllApmLocation $parameters
     * @return ResultInterface|Type\GiveMeAllApmLocationResponse
     * @throws SoapException
     */
    public function giveMeAllApmLocation(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllApmLocation $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeAllApmLocationResponse
    {
        return $this->call('GiveMeAllApmLocation', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePSDProvince $parameters
     * @return ResultInterface|Type\GiveMePSDProvinceResponse
     * @throws SoapException
     */
    public function giveMePSDProvince(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePSDProvince $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePSDProvinceResponse
    {
        return $this->call('GiveMePSDProvince', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMePSDZipcode $parameters
     * @return ResultInterface|Type\GiveMePSDZipcodeResponse
     * @throws SoapException
     */
    public function giveMePSDZipcode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePSDZipcode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMePSDZipcodeResponse
    {
        return $this->call('GiveMePSDZipcode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveMeCityPSDLocation $parameters
     * @return ResultInterface|Type\GiveMeCityPSDLocationResponse
     * @throws SoapException
     */
    public function giveMeCityPSDLocation(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeCityPSDLocation $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveMeCityPSDLocationResponse
    {
        return $this->call('GiveMeCityPSDLocation', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateBusinessPack $parameters
     * @return ResultInterface|Type\GenerateBusinessPackResponse
     * @throws SoapException
     */
    public function generateBusinessPack(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateBusinessPack $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateBusinessPackResponse
    {
        return $this->call('GenerateBusinessPack', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateBusinessPackTwo $parameters
     * @return ResultInterface|Type\GenerateBusinessPackTwoResponse
     * @throws SoapException
     */
    public function generateBusinessPackTwo(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateBusinessPackTwo $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateBusinessPackTwoResponse
    {
        return $this->call('GenerateBusinessPackTwo', $parameters);
    }

    /**
     * @param RequestInterface|Type\PutCustomerPackCanceled $parameters
     * @return ResultInterface|Type\PutCustomerPackCanceledResponse
     * @throws SoapException
     */
    public function putCustomerPackCanceled(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerPackCanceled $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerPackCanceledResponse
    {
        return $this->call('PutCustomerPackCanceled', $parameters);
    }

    /**
     * @param RequestInterface|Type\PutCustomerShippingCodeCanceled $parameters
     * @return ResultInterface|Type\PutCustomerShippingCodeCanceledResponse
     * @throws SoapException
     */
    public function putCustomerShippingCodeCanceled(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerShippingCodeCanceled $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerShippingCodeCanceledResponse
    {
        return $this->call('PutCustomerShippingCodeCanceled', $parameters);
    }

    /**
     * @param RequestInterface|Type\PutCustomerPack $parameters
     * @return ResultInterface|Type\PutCustomerPackResponse
     * @throws SoapException
     */
    public function putCustomerPack(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerPack $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\PutCustomerPackResponse
    {
        return $this->call('PutCustomerPack', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateNumberWaybills $parameters
     * @return ResultInterface|Type\GenerateNumberWaybillsResponse
     * @throws SoapException
     */
    public function generateNumberWaybills(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateNumberWaybills $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateNumberWaybillsResponse
    {
        return $this->call('GenerateNumberWaybills', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateOrlenPaczkaLabel $parameters
     * @return ResultInterface|Type\GenerateOrlenPaczkaLabelResponse
     * @throws SoapException
     */
    public function generateOrlenPaczkaLabel(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaLabel $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaLabelResponse
    {
        return $this->call('GenerateOrlenPaczkaLabel', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateOrlenPaczkaShippingCode $parameters
     * @return ResultInterface|Type\GenerateOrlenPaczkaShippingCodeResponse
     * @throws SoapException
     */
    public function generateOrlenPaczkaShippingCode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaShippingCode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaShippingCodeResponse
    {
        return $this->call('GenerateOrlenPaczkaShippingCode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateOrlenPaczkaReturn2Home $parameters
     * @return ResultInterface|Type\GenerateOrlenPaczkaReturn2HomeResponse
     * @throws SoapException
     */
    public function generateOrlenPaczkaReturn2Home(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaReturn2Home $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaReturn2HomeResponse
    {
        return $this->call('GenerateOrlenPaczkaReturn2Home', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateOrlenPaczkaShippingCodeReturn2Home $parameters
     * @return ResultInterface|Type\GenerateOrlenPaczkaShippingCodeReturn2HomeResponse
     * @throws SoapException
     */
    public function generateOrlenPaczkaShippingCodeReturn2Home(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaShippingCodeReturn2Home $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateOrlenPaczkaShippingCodeReturn2HomeResponse
    {
        return $this->call('GenerateOrlenPaczkaShippingCodeReturn2Home', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateStandardCustomerReturnShippingCode $parameters
     * @return ResultInterface|Type\GenerateStandardCustomerReturnShippingCodeResponse
     * @throws SoapException
     */
    public function generateStandardCustomerReturnShippingCode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateStandardCustomerReturnShippingCode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateStandardCustomerReturnShippingCodeResponse
    {
        return $this->call('GenerateStandardCustomerReturnShippingCode', $parameters);
    }

    /**
     * @param RequestInterface|Type\CreateCustomer $parameters
     * @return ResultInterface|Type\CreateCustomerResponse
     * @throws SoapException
     */
    public function createCustomer(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CreateCustomer $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CreateCustomerResponse
    {
        return $this->call('CreateCustomer', $parameters);
    }

    /**
     * @param RequestInterface|Type\GivePaymentType $parameters
     * @return ResultInterface|Type\GivePaymentTypeResponse
     * @throws SoapException
     */
    public function givePaymentType(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePaymentType $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePaymentTypeResponse
    {
        return $this->call('GivePaymentType', $parameters);
    }

    /**
     * @param RequestInterface|Type\GivePartnerStatus $parameters
     * @return ResultInterface|Type\GivePartnerStatusResponse
     * @throws SoapException
     */
    public function givePartnerStatus(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePartnerStatus $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePartnerStatusResponse
    {
        return $this->call('GivePartnerStatus', $parameters);
    }

    /**
     * @param RequestInterface|Type\GivePartnerStatusWithAllData $parameters
     * @return ResultInterface|Type\GivePartnerStatusWithAllDataResponse
     * @throws SoapException
     */
    public function givePartnerStatusWithAllData(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePartnerStatusWithAllData $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GivePartnerStatusWithAllDataResponse
    {
        return $this->call('GivePartnerStatusWithAllData', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPackList $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackListResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPackList(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackList $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackListResponse
    {
        return $this->call('GenerateLabelBusinessPackList', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPackListTwo $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackListTwoResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPackListTwo(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackListTwo $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackListTwoResponse
    {
        return $this->call('GenerateLabelBusinessPackListTwo', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPack $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPack(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPack $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackResponse
    {
        return $this->call('GenerateLabelBusinessPack', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPackTwo $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackTwoResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPackTwo(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackTwo $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackTwoResponse
    {
        return $this->call('GenerateLabelBusinessPackTwo', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetGeneratedParcels $parameters
     * @return ResultInterface|Type\GetGeneratedParcelsResponse
     * @throws SoapException
     */
    public function getGeneratedParcels(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetGeneratedParcels $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetGeneratedParcelsResponse
    {
        return $this->call('GetGeneratedParcels', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateProtocol $parameters
     * @return ResultInterface|Type\GenerateProtocolResponse
     * @throws SoapException
     */
    public function generateProtocol(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateProtocol $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateProtocolResponse
    {
        return $this->call('GenerateProtocol', $parameters);
    }

    /**
     * @param RequestInterface|Type\LabelPrintDuplicateList $parameters
     * @return ResultInterface|Type\LabelPrintDuplicateListResponse
     * @throws SoapException
     */
    public function labelPrintDuplicateList(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateList $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateListResponse
    {
        return $this->call('LabelPrintDuplicateList', $parameters);
    }

    /**
     * @param RequestInterface|Type\LabelPrintDuplicateListTwo $parameters
     * @return ResultInterface|Type\LabelPrintDuplicateListTwoResponse
     * @throws SoapException
     */
    public function labelPrintDuplicateListTwo(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateListTwo $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateListTwoResponse
    {
        return $this->call('LabelPrintDuplicateListTwo', $parameters);
    }

    /**
     * @param RequestInterface|Type\LabelPrintDuplicate $parameters
     * @return ResultInterface|Type\LabelPrintDuplicateResponse
     * @throws SoapException
     */
    public function labelPrintDuplicate(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicate $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateResponse
    {
        return $this->call('LabelPrintDuplicate', $parameters);
    }

    /**
     * @param RequestInterface|Type\LabelPrintDuplicateTwo $parameters
     * @return ResultInterface|Type\LabelPrintDuplicateTwoResponse
     * @throws SoapException
     */
    public function labelPrintDuplicateTwo(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateTwo $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\LabelPrintDuplicateTwoResponse
    {
        return $this->call('LabelPrintDuplicateTwo', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateShippingCode $parameters
     * @return ResultInterface|Type\GenerateShippingCodeResponse
     * @throws SoapException
     */
    public function generateShippingCode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateShippingCode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateShippingCodeResponse
    {
        return $this->call('GenerateShippingCode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GiveShippingCodeStatus $parameters
     * @return ResultInterface|Type\GiveShippingCodeStatusResponse
     * @throws SoapException
     */
    public function giveShippingCodeStatus(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveShippingCodeStatus $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GiveShippingCodeStatusResponse
    {
        return $this->call('GiveShippingCodeStatus', $parameters);
    }

    /**
     * @param RequestInterface|Type\ORLENPaczkaPoints $parameters
     * @return ResultInterface|Type\ORLENPaczkaPointsResponse
     * @throws SoapException
     */
    public function oRLENPaczkaPoints(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPoints $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPointsResponse
    {
        return $this->call('ORLENPaczkaPoints', $parameters);
    }

    /**
     * @param RequestInterface|Type\ORLENPaczkaPointsUpdate $parameters
     * @return ResultInterface|Type\ORLENPaczkaPointsUpdateResponse
     * @throws SoapException
     */
    public function oRLENPaczkaPointsUpdate(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPointsUpdate $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPointsUpdateResponse
    {
        return $this->call('ORLENPaczkaPointsUpdate', $parameters);
    }

    /**
     * @param RequestInterface|Type\ORLENPaczkaPointsLockersSchema $parameters
     * @return ResultInterface|Type\ORLENPaczkaPointsLockersSchemaResponse
     * @throws SoapException
     */
    public function oRLENPaczkaPointsLockersSchema(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPointsLockersSchema $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ORLENPaczkaPointsLockersSchemaResponse
    {
        return $this->call('ORLENPaczkaPointsLockersSchema', $parameters);
    }

    /**
     * @param RequestInterface|Type\WebhookRegister $parameters
     * @return ResultInterface|Type\WebhookRegisterResponse
     * @throws SoapException
     */
    public function webhookRegister(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookRegister $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookRegisterResponse
    {
        return $this->call('WebhookRegister', $parameters);
    }

    /**
     * @param RequestInterface|Type\WebhookUnregister $parameters
     * @return ResultInterface|Type\WebhookUnregisterResponse
     * @throws SoapException
     */
    public function webhookUnregister(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookUnregister $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookUnregisterResponse
    {
        return $this->call('WebhookUnregister', $parameters);
    }

    /**
     * @param RequestInterface|Type\WebhookStatus $parameters
     * @return ResultInterface|Type\WebhookStatusResponse
     * @throws SoapException
     */
    public function webhookStatus(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookStatus $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\WebhookStatusResponse
    {
        return $this->call('WebhookStatus', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPackAllegro $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackAllegroResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPackAllegro(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackAllegro $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackAllegroResponse
    {
        return $this->call('GenerateLabelBusinessPackAllegro', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateLabelBusinessPackListAllegro $parameters
     * @return ResultInterface|Type\GenerateLabelBusinessPackListAllegroResponse
     * @throws SoapException
     */
    public function generateLabelBusinessPackListAllegro(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackListAllegro $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateLabelBusinessPackListAllegroResponse
    {
        return $this->call('GenerateLabelBusinessPackListAllegro', $parameters);
    }

    /**
     * @param RequestInterface|Type\CustomerConfirmPackReturn $parameters
     * @return ResultInterface|Type\CustomerConfirmPackReturnResponse
     * @throws SoapException
     */
    public function customerConfirmPackReturn(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CustomerConfirmPackReturn $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CustomerConfirmPackReturnResponse
    {
        return $this->call('CustomerConfirmPackReturn', $parameters);
    }

    /**
     * @param RequestInterface|Type\CustomerGetPackagesToBeReturned $parameters
     * @return ResultInterface|Type\CustomerGetPackagesToBeReturnedResponse
     * @throws SoapException
     */
    public function customerGetPackagesToBeReturned(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CustomerGetPackagesToBeReturned $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CustomerGetPackagesToBeReturnedResponse
    {
        return $this->call('CustomerGetPackagesToBeReturned', $parameters);
    }

    /**
     * @param RequestInterface|Type\CallPickup $parameters
     * @return ResultInterface|Type\CallPickupResponse
     * @throws SoapException
     */
    public function callPickup(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CallPickup $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CallPickupResponse
    {
        return $this->call('CallPickup', $parameters);
    }

    /**
     * @param RequestInterface|Type\CallPickupNew $parameters
     * @return ResultInterface|Type\CallPickupNewResponse
     * @throws SoapException
     */
    public function callPickupNew(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CallPickupNew $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\CallPickupNewResponse
    {
        return $this->call('CallPickupNew', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetAvailablePickups $parameters
     * @return ResultInterface|Type\GetAvailablePickupsResponse
     * @throws SoapException
     */
    public function getAvailablePickups(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickups $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetAvailablePickupsResponse
    {
        return $this->call('GetAvailablePickups', $parameters);
    }

    /**
     * @param RequestInterface|Type\OrderPickupsFromLastDays $parameters
     * @return ResultInterface|Type\OrderPickupsFromLastDaysResponse
     * @throws SoapException
     */
    public function orderPickupsFromLastDays(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\OrderPickupsFromLastDays $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\OrderPickupsFromLastDaysResponse
    {
        return $this->call('OrderPickupsFromLastDays', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateCustomerReturn $parameters
     * @return ResultInterface|Type\GenerateCustomerReturnResponse
     * @throws SoapException
     */
    public function generateCustomerReturn(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateCustomerReturn $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateCustomerReturnResponse
    {
        return $this->call('GenerateCustomerReturn', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateCustomerReturnShippingCode $parameters
     * @return ResultInterface|Type\GenerateCustomerReturnShippingCodeResponse
     * @throws SoapException
     */
    public function generateCustomerReturnShippingCode(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateCustomerReturnShippingCode $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateCustomerReturnShippingCodeResponse
    {
        return $this->call('GenerateCustomerReturnShippingCode', $parameters);
    }

    /**
     * @param RequestInterface|Type\GenerateStandardCustomerReturn $parameters
     * @return ResultInterface|Type\GenerateStandardCustomerReturnResponse
     * @throws SoapException
     */
    public function generateStandardCustomerReturn(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateStandardCustomerReturn $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateStandardCustomerReturnResponse
    {
        return $this->call('GenerateStandardCustomerReturn', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetLabelGraphic $parameters
     * @return ResultInterface|Type\GetLabelGraphicResponse
     * @throws SoapException
     */
    public function getLabelGraphic(\Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetLabelGraphic $parameters) : \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GetLabelGraphicResponse
    {
        return $this->call('GetLabelGraphic', $parameters);
    }


}

