<?php

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Hook\HookExecutor;
use Orlen\OrlenPaczka\Installer\ModuleInstaller;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

if(!defined('_PS_VERSION_'))
    exit;


include_once _PS_MODULE_DIR_ . 'orlenpaczka/vendor/autoload.php';

class orlenpaczka extends CarrierModule
{
    public $id_carrier = -1;

    public function __construct()
    {
        $this->name = 'orlenpaczka';
        $this->tab = 'others';
        $this->version = '1.0.5';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->trans('ORLEN Paczka', [], 'Modules.Orlenpaczka.Admin');
        $this->controllers = ['default'];
        $this->ps_versions_compliancy = array('min' => '1.7.8', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        $installer = new ModuleInstaller();
        $configuration = new ConfigurationModule();
        $this->setUpRoutingLoaderResolver();

        $result = parent::install() && $installer->install($configuration);

        return $this->fixSymfionyClearCache($result);
    }

    public function uninstall()
    {
        $installer = new ModuleInstaller();
        $configuration = new ConfigurationModule();
        $result = $installer->uninstall($configuration) && parent::uninstall();

        return $this->fixSymfionyClearCache($result);
    }

    private function fixSymfionyClearCache(bool $result): bool
    {
        $sfContainer = SymfonyContainer::getInstance();
        $containerFile = (new \ReflectionObject($sfContainer))->getFileName();
        $fileTime = filemtime($containerFile);
        if ($_SERVER['REQUEST_TIME'] <= $fileTime) {
            $_SERVER['REQUEST_TIME'] += (($fileTime + 1) - $_SERVER['REQUEST_TIME']);
        }

        if (80100 <= PHP_VERSION_ID) {
            return $result;
        }

        try {
            /** @var EventDispatcher $eventDispatcher */
            $eventDispatcher = $this->get('event_dispatcher');
            $eventDispatcher->addListener(KernelEvents::TERMINATE, function () {
                Module::$_INSTANCE = [];
            }, -10000);
        } catch (Exception $e) {
        }

        return $result;
    }

    public function __call(string $methodName, array $params)
    {
        $hookExecutor = $this->get(HookExecutor::class);

        $methodName = ucfirst(substr($methodName, 4));
        return $hookExecutor->execute($methodName, $params);
    }


    public function isUsingNewTranslationSystem()
    {
        return true;
    }

    private function isContainerConfigLoaded()
    {
        if ($this->active) {
            return true;
        }

        if (Tools::version_compare(_PS_VERSION_, '8.0.0') || Tools::version_compare(_PS_VERSION_, '9.0.0', '>=')) {
            return true;
        }

        return $this->hasShopAssociations();
    }

    public function getContent()
    {
        try{
            /** @var UrlGeneratorInterface $router */
            $router = $this->getContainer()->get('router');
            if (!$this->isContainerConfigLoaded()) {
                $this->addFlash($this->l('To access the configuration page, the module must be active.'));
                Tools::redirectAdmin($router->generate('admin_module_manage'));
            }
            Tools::redirectAdmin($router->generate('orlenpaczka.config.authorization.index'));
        }catch (RouteNotFoundException $e) {
            if (!Tools::getValue('cache_cleared')) {
                Tools::clearSf2Cache();
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true, [], [
                    'configure' => $this->name,
                    'cache_cleared' => true,
                ]));
            }
            throw $e;
        }
    }

    private function addFlash(string $message, string $type = 'error'): void
    {
        try {
            $session = $this->get('session');
            $session->getFlashBag()->add($type, $message);
        } catch (ServiceNotFoundException $e) {
        }
    }



    private function setUpRoutingLoaderResolver()
    {
        if (Tools::version_compare(_PS_VERSION_, '1.7.7')) {
            return;
        }

        try {
            $this->get('routing.loader');
        } catch (Exception $e) {
            // ignore silently
        }
    }


    public function getOrderShippingCost($params, $shipping_cost)
    {
        $carrier = new Carrier($this->id_carrier);
        $shipment = $this->get(ShipmentRepository::class)->findOneBy(['carrier' => $carrier->id_reference]);
        if (!$shipment || !$shipment->getCarrierActive()) {
            return false;
        }
        return $shipping_cost;

    }

    public function getOrderShippingCostExternal($params)
    {
        return true;
    }


}
