<?php

use Orlen\OrlenPaczka\Entity\SelectedPoint;
use Orlen\OrlenPaczka\Repository\SelectedPointRepository;

class OrlenpaczkaPointsModuleFrontController extends ModuleFrontController
{
    public function displayAjaxSaveSelectedPoint()
    {
        $idCart = $this->context->cart->id;
        $selectedPointRepository = $this->get(SelectedPointRepository::class);
        $selectedPoint = $selectedPointRepository->findOneBy(['cart' => $idCart, 'carrier' => Tools::getValue('carrierId')]);
        if (!$selectedPoint) {
            $selectedPoint = new SelectedPoint();
        }

        $selectedPoint->setCart($idCart);
        $selectedPoint->setName(Tools::getValue('name'));
        $selectedPoint->setCarrier((int) Tools::getValue('carrierId'));
        $selectedPoint->setPoint(Tools::getValue('id'));
        $selectedPoint->setDestinationCode(Tools::getValue('destinationCode'));
        $selectedPoint->setAddress(Tools::getValue('address'));
        $selectedPoint->setCity(Tools::getValue('city'));
        $selectedPoint->setPostalCode(Tools::getValue('postalCode'));
        $selectedPoint->setProvince(Tools::getValue('province'));
        $selectedPoint->setLatitude(Tools::getValue('latitude'));
        $selectedPoint->setLongitude(Tools::getValue('longitude'));
        $result = $selectedPointRepository->add($selectedPoint);
        return $this->_returnResponseAjax(['carrierId' => Tools::getValue('carrierId')]);
    }

    private function _returnResponseAjax($data)
    {

        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data);
        exit;
    }
}
