/**
 * Orlen Package Tabs JavaScript
 * 
 * Odpowiada za obsługę przełączania między paczkami
 */
$(document).ready(function() {
  // Funkcja przełączająca widok paczek
  function switchPackage(packageIndex) {
    // Aktywacja przycisku
    $('.package-tab').removeClass('btn-primary').addClass('btn-outline-primary');
    $(`.package-tab[data-package-index="${packageIndex}"]`).removeClass('btn-outline-primary').addClass('btn-primary');
    
    // Ukrycie wszystkich szczegółów paczek i pokazanie wybranej
    $('.package-details').hide();
    $(`#package-details-${packageIndex}`).show();
    
    // Ukrycie wszystkich akcji etykiet i pokazanie wybranej
    $('.label-actions').hide();
    $(`#label-actions-${packageIndex}`).show();
    
    // Ukrycie wszystkich informacji o protokole i pokazanie wybranej
    $('.protocol-info').hide();
    $(`#protocol-info-${packageIndex}`).show();
    
    // Aktualizacja przycisku Change Pickup Point
    $('.change-pickup-button').addClass('d-none');
    $(`.change-pickup-button[data-package-index="${packageIndex}"]`).removeClass('d-none');
  }
  
  // Obsługa kliknięcia w zakładkę paczki
  $('.package-tab').on('click', function() {
    const packageIndex = $(this).data('package-index');
    switchPackage(packageIndex);
  });
});
