<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    Waynet
 * @copyright Waynet
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

namespace Orlen\OrlenPaczka\Tabs;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Orlen\OrlenPaczka\Tabs\Interfaces\TabInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;
use Twig\Environment;

abstract class AbstractTab implements TabInterface
{
    protected $collection = [];

    protected $active = 0;
    protected $url = null;

    /**
     * @var Translator
     */
    protected $translator;
    protected RouterInterface $router;

    public function __construct(Translator $translator, RouterInterface $router)
    {
        $this->translator = $translator;
        $this->router = $router;
    }

    /**
     * @return CollectionTabs
     */
    public function getCollection(): CollectionTabs
    {
        return $this->collection;
    }

    /**
     * @param CollectionTabs $collection
     */
    public function setCollection(CollectionTabs $collection): void
    {
        $this->collection = $collection;
    }

    /**
     * @return mixed
     */
    public function isActive()
    {
        return (bool) $this->active;
    }

    public function changeActive(bool $active)
    {
        $this->active = $active;
    }

    /**
     * @param bool $active
     */
    public function setActive(): void
    {
        /* @var AbstractTab $tab */
        foreach ($this->collection->getCollection() as $tab) {
            $tab->changeActive(false);
        }
        $this->active = true;
    }

    public function getUrl()
    {
        if ($this->url){
            return $this->url;
        }

        return $this->getDefaultRoute();
    }

    public function setUrl($url)
    {
        $this->url = $url;
    }

    abstract public function getDefaultRoute();

}
