<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Wsdl\Loader;

use Orlen\OrlenPaczka\Soap\Wsdl\Exception\UnloadableWsdlException;

final class CallbackLoader implements WsdlLoaderInterface
{
    /**
     * @param callable(string): string $callback
     */
    private $callback;

    /**
     * @param callable(string): string $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback;
    }

    /**
     * @throws UnloadableWsdlException
     */
    public function load(string $location): string
    {
        try {
            return ($this->callback)($location);
        } catch (UnloadableWsdlException $e) {
            throw $e;
        } catch (\Exception $e) {
            throw UnloadableWsdlException::fromException($e);
        }
    }
}
