<?php

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine;

use Orlen\OrlenPaczka\Exception\XmlStatusCodeException;
use PrestaShopBundle\Install\SimplexmlElement;


class XmlSoapDecoder
{
    /**
     * @var mixed
     */
    private $mapped;

    public function decode(\SimpleXMLElement $xml, \SimpleXMLElement $schema, bool $checkError)
    {
        $this->getSchema($schema);
        $object = $this->createObjectFromXml($xml, $checkError);
        return $object;
    }


    private function getSchema(\SimpleXMLElement $schema)
    {
        $this->mapped = [];
        foreach ($schema->xpath('//xs:element') as $element) {
            if (isset($element->attributes()->type)) {
                $this->mapped[(string)$element->attributes()->name] = (string)$element->attributes()->type;
            }
        }
    }

    private function createObjectFromXml(\SimpleXMLElement $xml, $checkError) {
        $error = '000';
        $errorDescription = '';
        $object = new \stdClass();
        foreach ($xml->children() as $fieldName => $fieldValue) {
            if (count($fieldValue->children()) > 0) {
                $object->$fieldName[] = $this->createObjectFromXml($fieldValue, $checkError);
            }else{
                if ($fieldName == 'Err' && (string)$fieldValue !== '000') {
                    $error = (string)$fieldValue;
                }
                if ($error !== '000' && $fieldName == 'ErrDes'){
                    $errorDescription = (string)$fieldValue;
                }
                if (isset($this->mapped[$fieldName])) {

                    switch ($this->mapped[$fieldName]) {
                        case 'xs:boolean':
                            $object->$fieldName = filter_var($fieldValue, FILTER_VALIDATE_BOOLEAN);
                            break;
                        case 'xs:int':
                        case 'xs:integer':
                            $object->$fieldName = (int)$fieldValue;
                            break;
                        case 'xs:double':
                        case 'xs:decimal':
                        case 'xs:float':
                            $object->$fieldName = (float)$fieldValue;
                            break;
                        case 'xs:string':
                        default:
                            $object->$fieldName = (string)$fieldValue;
                            break;
                    }
                }else{
                    $object->$fieldName = (string)$fieldValue;
                }
            }
        }
        if ($error !== '000' && $error !== '0' ) {
            if ($checkError){
                throw new XmlStatusCodeException($errorDescription);
            }else{
                try{
                    throw new XmlStatusCodeException($errorDescription);
                }catch (XmlStatusCodeException $e){

                }
            }
        }
        return $object;
    }

}
