<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine\Wsdl;

/**
 * This provider can be used to pass in a raw WSDL file.
 */
final class InMemoryWsdlProvider implements WsdlProviderInterface
{
    public function getWsdl(string $source): string
    {
        return 'data://text/plain;base64,' . base64_encode($source);
    }
}
