<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine\Transport;

use Orlen\OrlenPaczka\Soap\Engine\HttpBinding\SoapRequest;
use Orlen\OrlenPaczka\Soap\Engine\HttpBinding\SoapResponse;
use Orlen\OrlenPaczka\Soap\Engine\TransportInterface;

final class ExtSoapServerTransport implements TransportInterface
{
    /**
     * @var \SoapServer
     */
    private $server;

    public function __construct(\SoapServer $server)
    {
        $this->server = $server;
    }

    public function request(SoapRequest $request): SoapResponse
    {
        ob_start();
        $this->server->handle($request->getRequest());
        $responseBody = ob_get_clean();

        return new SoapResponse($responseBody);
    }
}
