<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine\Transport;

use Orlen\OrlenPaczka\Soap\Engine\HttpBinding\SoapRequest;
use Orlen\OrlenPaczka\Soap\Engine\HttpBinding\SoapResponse;
use Orlen\OrlenPaczka\Soap\Engine\TransportInterface;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\AbusedClient;

final class ExtSoapClientTransport implements TransportInterface
{
    /**
     * @var AbusedClient
     */
    private $client;

    public function __construct(AbusedClient $client)
    {
        $this->client = $client;
    }

    public function request(SoapRequest $request): SoapResponse
    {
        $response = $this->client->doActualRequest(
            $request->getRequest(),
            $request->getLocation(),
            $request->getAction(),
            $request->getVersion(),
            $request->getOneWay()
        );

        return new SoapResponse($response);
    }
}
