<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\XsdType;

/**
 * @implements \IteratorAggregate<int, XsdType>
 */
final class XsdTypeCollection implements \Countable, \IteratorAggregate
{
    /**
     * @var list<XsdType>
     */
    private $types;

    /**
     * @no-named-arguments
     */
    public function __construct(XsdType ...$types)
    {
        $this->types = $types;
    }

    /**
     * @return \Iterator<int, XsdType>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->types);
    }

    public function count(): int
    {
        return count($this->types);
    }

    public function map(callable $callback): array
    {
        return array_map($callback, $this->types);
    }

    public function getByNameWithFallback(string $name): XsdType
    {
        foreach ($this->types as $type) {
            if ($name === $type->getName()) {
                return $type;
            }
        }

        return XsdType::guess($name);
    }
}
