<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\Property;

/**
 * @implements \IteratorAggregate<int, Property>
 */
final class PropertyCollection implements \Countable, \IteratorAggregate
{
    /**
     * @var list<Property>
     */
    private $properties;

    /**
     * @no-named-arguments
     */
    public function __construct(Property ...$properties)
    {
        $this->properties = $properties;
    }

    /**
     * @return \Iterator<int, Property>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->properties);
    }

    public function count(): int
    {
        return count($this->properties);
    }

    public function map(callable $callback): array
    {
        return array_map($callback, $this->properties);
    }
}
