<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Engine;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\MetadataInterface;

final class Engine implements EngineInterface
{
    private $driver;
    private $transport;

    public function __construct(DriverInterface $driver, TransportInterface $transport)
    {
        $this->driver = $driver;
        $this->transport = $transport;
    }

    public function request(string $method, array $arguments)
    {
        $request = $this->driver->encode($method, $arguments);
        $response = $this->transport->request($request);

        return $this->driver->decode($method, $response);
    }

    public function getMetadata(): MetadataInterface
    {
        return $this->driver->getMetadata();
    }
}
