<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Client\Caller;

use Orlen\OrlenPaczka\Soap\Client\Exception\SoapException;
use Orlen\OrlenPaczka\Soap\Client\Exception\SoapFault;
use Orlen\OrlenPaczka\Soap\Client\Type\MixedResult;
use Orlen\OrlenPaczka\Soap\Client\Type\MultiArgumentRequestInterface;
use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;
use Orlen\OrlenPaczka\Soap\Client\Type\ResultInterface;
use Orlen\OrlenPaczka\Soap\Client\Type\ResultProviderInterface;
use Orlen\OrlenPaczka\Soap\Engine\EngineInterface;

final class EngineCaller implements CallerInterface
{
    /**
     * @var EngineInterface
     */
    private $engine;

    public function __construct(EngineInterface $engine)
    {
        $this->engine = $engine;
    }

    public function call(string $method, RequestInterface $request): ResultInterface
    {
        try {
            $arguments = $request instanceof MultiArgumentRequestInterface
                ? $request->getArguments()
                : [$request];
            $result = $this->engine->request($method, $arguments);

            if ($result instanceof ResultProviderInterface) {
                $result = $result->getResult();
            }

            if (!$result instanceof ResultInterface) {
                $result = new MixedResult($result);
            }

            return $result;
        } catch (\SoapFault $fault) {
            throw SoapFault::fromNative($fault);
        } catch (\Exception $exception) {
            throw SoapException::fromThrowable($exception);
        }
    }

    public function __invoke(string $method, RequestInterface $request): ResultInterface
    {
        return $this->call($method, $request);
    }
}
